Extension { #name : 'ObsoleteSymbolAssociation' }

{ #category : 'Repository Conversion' }
ObsoleteSymbolAssociation class >> _correspondingNewClass [

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteSymbolAssociation)
  ifTrue: [ ^ SymbolAssociation ].

^ self.

]

{ #category : 'Private' }
ObsoleteSymbolAssociation >> _resolveRcConflictsWith: conflictObjects [

"A logical write-write conflict has occurred on the receiver.  This
 may have occurred due to artificially placing the receiver in the write
 set when a subclass re-implemented this method (this is done to maintain
 cache coherency. See if the state has changed in this transaction.  If
 so, then it is a valid conflict (and returns false); otherwise returns true."

| preAbortValue |
preAbortValue := value.
self _selectiveAbort.
^ value == preAbortValue

]

{ #category : 'Repository Conversion' }
ObsoleteSymbolAssociation >> convertTo5 [

"Converts the receiver from an instance of ObsoleteSymbolAssociation
 to an instance of SymbolAssociation without changing its identity.
 Returns the converted receiver."

<primitive: 472>

self _primitiveFailed: #convertTo5.

]
