Extension { #name : 'ObsoleteSymbol' }

{ #category : 'Repository Conversion' }
ObsoleteSymbol class >> _correspondingNewClass [

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteSymbol)
  ifTrue: [ ^ Symbol ].

^ self.

]

{ #category : 'Storing and Loading' }
ObsoleteSymbol class >> loadFrom: passiveObj [

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| inst |

"since ObsoleteSymbols can't refer to other objects, the 'hasRead:' message
 may be sent after values have been filled in.  Subclasses of ObsoleteSymbol
 that contain pointer variables must reimplement this method"

inst := String new .
inst size: passiveObj readSize.
inst loadFrom: passiveObj .
inst changeClassTo: self.
^inst

]

{ #category : 'Comparing' }
ObsoleteSymbol >> = aCharCollection [

"Returns true if the receiver is equivalent to the argument, returns false
 otherwise."

aCharCollection _isSymbol ifTrue:[
  "Use the primitive in Symbol for special behavior of ObsoleteSymbols."
  ^ aCharCollection = self
  ].
^ super = aCharCollection

]

{ #category : 'Converting' }
ObsoleteSymbol >> asObsoleteSymbol [

"Returns the receiver."

^ self

]

{ #category : 'Converting' }
ObsoleteSymbol >> asObsoleteSymbolKind [

"Equivalent to asObsoleteSymbol."

 ^self

]

{ #category : 'Converting' }
ObsoleteSymbol >> asString [

"Returns a copy of the receiver as an instance of class String."

^ String withAll: self

]

{ #category : 'Converting' }
ObsoleteSymbol >> asSymbol [

"Returns a copy of the receiver as an instance of class Symbol."

^ Symbol withAll: self

]

{ #category : 'Repository Conversion' }
ObsoleteSymbol >> convertTo5 [

"Returns a copy of the receiver as an instance of class Symbol."

^ Symbol withAll: self

]

{ #category : 'Converting' }
ObsoleteSymbol >> copy [

"Returns a copy of the receiver."

^ ObsoleteSymbol withAll: self

]

{ #category : 'Testing' }
ObsoleteSymbol >> isObsoleteSymbol [

"Returns true."

 ^true

]

{ #category : 'Formatting' }
ObsoleteSymbol >> printOn: aStream [

"Puts a displayable representation of the receiver on the given stream.
 That representation conforms to GemStone Smalltalk parsing rules."

| mySize |
(mySize := self size) == 0 ifTrue:[
  aStream nextPut: $# .
  aStream nextPut: $' .
  aStream nextPut: $' .
  ]
ifFalse:[
  mySize < 50 ifTrue:[
    self containsSeparator   "containsSeparator is expensive"
    ifFalse:[
      aStream nextPut: $# .
      aStream nextPutAll: self
      ]
    ifTrue:[
      aStream nextPut: $# .
      super printOn: aStream
      ]
    ]
  ifFalse:[
    "do it the efficient way for large ObsoleteSymbols"
    aStream nextPut: $# .
    super printOn: aStream
    ]
  ]

]

{ #category : 'Repository Conversion' }
ObsoleteSymbol >> transformIntoString [

"Private. Transforms the receiver from an ObsoleteSymbol to a
 String while keeping its identity the same."

<primitive: 488>
self _primitiveFailed: #transformIntoString

]

{ #category : 'Repository Conversion' }
ObsoleteSymbol >> transformIntoSymbol [

"Private. Attempts to transform the receiver from an ObsoleteSymbol to a
 Symbol while keeping its identity the same. If retaining the identity is not
 possible, returns a Symbol with the same contents."

<primitive: 479>
self _primitiveFailed: #transformIntoSymbol

]

{ #category : 'Formatting' }
ObsoleteSymbol >> withNoColons [

"Returns a copy of the receiver with all colons removed."

^self copyWithout: $:

]
