Extension { #name : 'ObsoleteLanguageDictionary' }

{ #category : 'Repository Conversion' }
ObsoleteLanguageDictionary class >> _correspondingNewClass [

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteLanguageDictionary)
  ifTrue: [ ^ LanguageDictionary ].

^ self.

]

{ #category : 'Storing and Loading' }
ObsoleteLanguageDictionary class >> loadFrom: passiveObj [

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

^ self loadFrom: passiveObj mappingToClass: LanguageDictionary

]

{ #category : 'Repository Conversion' }
ObsoleteLanguageDictionary >> rehashForConversion [

"Private. Converts the receiver to an instance of Dictionary. Only done if
 the receiver is an instance of ObsoleteDictionary. Instances of subclasses
 of ObsoleteDictionary are not converted. Returns the receiver."

<primitive: 2001> "enter protected mode"
| prot |
prot := System _protectedMode .
[
  | newDict anArray aSet |

  self class == ObsoleteLanguageDictionary ifFalse: [
    ^ self
  ].

  anArray := Array new.
  aSet := IdentitySet new.
  self associationsDo: [ :anAssoc |
    anArray add: anAssoc.
    aSet add: anAssoc class
    ].

  "If all the ObsoleteSymbolAssociations  have not been converted to
   SymbolAssociation, retain the receiver as an ObsoleteLanguageDictionary."
  (aSet includes: ObsoleteSymbolAssociation)
    ifTrue: [ ^ self ].

  newDict := LanguageDictionary new: (self size).
  newDict objectSecurityPolicy: self objectSecurityPolicy.
  newDict _becomeDictionary: self.
  anArray accompaniedBy: self do: [ :me :anAssoc | me add: anAssoc ].
] ensure:[
  prot _leaveProtectedMode
].
^ self

]

{ #category : 'Accessing' }
ObsoleteLanguageDictionary >> value [

"Returns the value associated with the user's native language symbol.  The
 user's language symbol is taken from his UserProfile object.  If there is no
 entry for the given language, an error is generated."

|myLanguage "the Symbol representing the user's native language"|

myLanguage := System myUserProfile nativeLanguage.
^ self at: myLanguage
       ifAbsent: [^ self _errorKeyNotFound: myLanguage]

]
