Extension { #name : 'UnicodeIndexSpecification' }

{ #category : 'instance creation' }
UnicodeIndexSpecification class >> path: aString collator: anIcuCollator [
  | res |
  (res := self new)
    path: aString;
    collator: anIcuCollator .
  ^ res

]

{ #category : 'instance creation' }
UnicodeIndexSpecification class >> path: aString lastElementClass: aClass [
  ^ self shouldNotImplement: #'path:lastElementClass:'

]

{ #category : 'accessing' }
UnicodeIndexSpecification >> _createIndex [
  | index |
  index := self equalityIndexClass newWithCollator: self collator.
  self legacyIndex
    ifFalse: [
      index
        options: self options;
        constraintType: self constraintType ].
  ^ index

]

{ #category : 'private' }
UnicodeIndexSpecification >> _validateLastElementClassOn: anNsc [
  "noop"



]

{ #category : 'accessing' }
UnicodeIndexSpecification >> collator [
  "Returns IcuCollator to be used when comparing Unicode strings"

  collator ifNil: [ collator := IcuCollator default copy immediateInvariant ].
  ^ collator

]

{ #category : 'accessing' }
UnicodeIndexSpecification >> collator: anIcuCollator [
  "Set the receiver's collator. Use a copy of anIcuCollator to disallow
   changes to strength, etc, that might affect the sort ordering. "

  collator := anIcuCollator copy immediateInvariant

]

{ #category : 'accessing' }
UnicodeIndexSpecification >> constraintType [
  ^ self dynamicInstVarAt: #'constraintType'

]

{ #category : 'accessing' }
UnicodeIndexSpecification >> constraintType: aSymbolOrNil [
  " #unicode ... if not nil, optimizedComparison option should be set as well. "

  self dynamicInstVarAt: #'constraintType' put: aSymbolOrNil

]

{ #category : 'accessing' }
UnicodeIndexSpecification >> equalityIndexClass [
  ^ self legacyIndex
    ifTrue: [ UnicodeRangeEqualityIndex ]
    ifFalse: [ GsUnicodeRangeEqualityIndex ]

]

{ #category : 'accessing' }
UnicodeIndexSpecification >> indexTypePrintString [
  ^ self constraintType
      ifNil: [ 'unicodeIndex' ]
      ifNotNil: [:constraint |
        "constraint  == #unicodeString"
        'unicodeStringOptimizedIndex' ]

]

{ #category : 'accessing' }
UnicodeIndexSpecification >> options [
  "if constraintType is not set, then ensure that optimizedComparison option is cleared"

  self constraintType ifNotNil: [ ^ super options ].
  ^ super options clearOptimizedComparison

]
