Extension { #name : 'Uint64Array' }

{ #category : 'Instance Creation' }
Uint64Array class >> new: aSize [

^ self _basicNew:  aSize * 8

]

{ #category : 'Accessing' }
Uint64Array >> at: anOffset [

"Returns an Integer containing a 64bit unsigned value."

<primitive: 1076>
(anOffset _isSmallInteger)
  ifTrue: [^ self _errorIndexOutOfRange: anOffset]
  ifFalse: [^ self _errorNonIntegerIndex: anOffset].
^ self _primitiveFailed: #at: args: { anOffset } .

]

{ #category : 'Updating' }
Uint64Array >> at: anOffset put: aValue [

"aValue must be an Integer representable as a 64bit unsigned integer.
 returns aValue ."

<primitive: 1077>
| max |
max := 18446744073709551615 .
aValue _validateClass: Integer .
(aValue < 0 or:[ aValue > max ]) ifTrue:[
  aValue _error: #rtErrArgOutOfRange args:{ 0 . max }
].
(anOffset _isSmallInteger) ifTrue: [
  ((anOffset > (self size + 1)) or: [anOffset < 1]) ifTrue: [
    ^ self _errorIndexOutOfRange: anOffset
  ]
] ifFalse: [
  ^ self _errorNonIntegerIndex: anOffset
] .
self _primitiveFailed: #codePointAt:put: args: { anOffset . aValue }

]

{ #category : 'Accessing' }
Uint64Array >> size [

"Returns the number of elements in the receiver."

^ self _basicSize // 8.

]

{ #category : 'Updating' }
Uint64Array >> size: anInteger [

"Changes the size of the receiver to anInteger.

 If anInteger is less than the current size of the receiver, the receiver is
 shrunk accordingly.  If anInteger is greater than the current size of the
 receiver, the receiver is extended and new elements are initialized to zero."

^ super _basicSize: 8 * anInteger

]
