Extension { #name : 'Uint32Array' }

{ #category : 'Instance Creation' }
Uint32Array class >> new: aSize [

^ self _basicNew:  aSize * 4

]

{ #category : 'Accessing' }
Uint32Array >> at: anOffset [

"Returns a 32bit unsigned value as a SmallInteger."

<primitive: 1073>
(anOffset _isSmallInteger)
  ifTrue: [^ self _errorIndexOutOfRange: anOffset]
  ifFalse: [^ self _errorNonIntegerIndex: anOffset].
^ self _primitiveFailed: #at: args: { anOffset } .

]

{ #category : 'Updating' }
Uint32Array >> at: anOffset put: aValue [

"aValue must be a SmallInteger representable as a 32bit unsigned integer.
 returns aValue ."

<primitive: 1075>
aValue _validateClass: SmallInteger .
(aValue < 0 or:[ aValue > 4294967295]) ifTrue:[
  aValue _error: #rtErrArgOutOfRange args:{ 0 . 4294967295 }
].
(anOffset _isSmallInteger) ifTrue: [
  ((anOffset > (self size + 1)) or: [anOffset < 1]) ifTrue: [
    ^ self _errorIndexOutOfRange: anOffset
  ]
] ifFalse: [
  ^ self _errorNonIntegerIndex: anOffset
] .
self _primitiveFailed: #at:put: args: { anOffset . aValue }

]

{ #category : 'Accessing' }
Uint32Array >> size [

"Returns the number of elements in the receiver."

^ self _basicSize // 4.

]

{ #category : 'Updating' }
Uint32Array >> size: anInteger [

"Changes the size of the receiver to anInteger.

 If anInteger is less than the current size of the receiver, the receiver is
 shrunk accordingly.  If anInteger is greater than the current size of the
 receiver, the receiver is extended and new elements are initialized to zero."

^ super _basicSize: 4 * anInteger

]
