Extension { #name : 'Uint16Array' }

{ #category : 'Instance Creation' }
Uint16Array class >> new: aSize [

^ self _basicNew:  aSize * 2

]

{ #category : 'Accessing' }
Uint16Array >> at: anOffset [

"Returns a 16 bit unsigned integer as a SmallInteger."

<primitive: 1072>
(anOffset _isSmallInteger)
  ifTrue: [^ self _errorIndexOutOfRange: anOffset]
  ifFalse: [^ self _errorNonIntegerIndex: anOffset].
^ self _primitiveFailed: #at: args: { anOffset } .

]

{ #category : 'Updating' }
Uint16Array >> at: anOffset put: aValue [

"aValue must be a SmallInteger representable as a 16bit unsigned integer.
 returns aValue ."

<primitive: 254>
aValue _validateClass: SmallInteger .
(aValue < 0 or:[ aValue > 65535]) ifTrue:[
  aValue _error: #rtErrArgOutOfRange args:{ 0 . 65535 }
].
(anOffset _isSmallInteger) ifTrue: [
  ((anOffset > (self size + 1)) or: [anOffset < 1]) ifTrue: [
    ^ self _errorIndexOutOfRange: anOffset
  ]
] ifFalse: [
  ^ self _errorNonIntegerIndex: anOffset
] .
self _primitiveFailed: #at:put: args: { anOffset . aValue }

]

{ #category : 'Accessing' }
Uint16Array >> size [

"Returns the number of elements in the receiver."

^ self _basicSize // 2.

]

{ #category : 'Updating' }
Uint16Array >> size: anInteger [

"Changes the size of the receiver to anInteger.

 If anInteger is less than the current size of the receiver, the receiver is
 shrunk accordingly.  If anInteger is greater than the current size of the
 receiver, the receiver is extended and new elements are initialized to zero."

^ super _basicSize: 2 * anInteger

]
