"
SortBlockUnicodeNode is a concrete class that along with the class BlockSorter implements the 
 behavior used to sort collections efficiently. It is an interface to an algorithm based 
 on an efficient merge-sort.

Constraints:
	numElements: SmallInteger
	blockSorter: Object
	totalElements: Object
"
Class {
	#name : 'SortBlockUnicodeNode',
	#superclass : 'SortBlockNode',
	#instVars : [
		'collator'
	],
	#category : 'Indexing-Btree-Internals'
}

{ #category : 'Comparison Operators' }
SortBlockUnicodeNode >> _compareEntryAt: index1
lessThanNode: aNode
entryAt: index2
useValue: aBoolean [

"Perform a < comparison between the entries at the given indexes.
 The default implementation uses no encryption."

| o1 o2 blk |
" first compare the keys "
((blk := blockSorter sortBlock) value: (o1 := self _at: index1)
                               value: (o2 := aNode _at: index2) value: collator)
   ifTrue: [ ^ true ]
   ifFalse: [
      " if using the values and keys are equal, use the OOP of the value "
      (blk value: o2  value: o1 value: collator )
        ifFalse: [ ^ (self _at: index1 - 1) identityHash < (aNode _at: index2 - 1) identityHash ]
        ifTrue: [ ^ false ]
     ]

]

{ #category : 'Comparison Operators' }
SortBlockUnicodeNode >> _compareKey: aKey greaterThanEntryAt: index [

  ^ blockSorter sortBlock value: (self _at: index) value: aKey value: collator

]

{ #category : 'Comparison Operators' }
SortBlockUnicodeNode >> _compareKey: aKey lessThanEntryAt: index [

  ^ blockSorter sortBlock value: aKey value: (self _at: index) value: collator

]

{ #category : 'Updating' }
SortBlockUnicodeNode >> _insertDuplicateKey: aKey value: aValue atIndex: insertionIndex [
  "The given key is already present in the receiver, so insert the entry
 in a secondary sort node (creating it if necessary)."

  | val newNode sortArray |
  " get the existing value "
  val := self _at: insertionIndex.
  val class == SortNodeArray
    ifTrue: [
      " value is already sort nodes on the secondary sort path "
      blockSorter _addObject: aValue inNodes: val ]
    ifFalse: [
      " create sort node for the secondary sort path and put it in a sort Array "
      newNode := blockSorter sortNodeClassForSort new: self sizeForSecondarySorts.
      newNode blockSorter: blockSorter collator: collator .
      sortArray := SortNodeArray with: newNode .
      self _basicAt: insertionIndex put: sortArray.
      blockSorter _addObject: aValue inNodes: sortArray.
      blockSorter _addObject: val inNodes: sortArray ]

]

{ #category : 'Updating' }
SortBlockUnicodeNode >> blockSorter: aBlockSorter collator: anIcuCollator [

blockSorter := aBlockSorter .
collator := anIcuCollator

]
