Extension { #name : 'SmallInteger' }

{ #category : 'Converting' }
SmallInteger >> asSymbol [

"Returns a Symbol that indicates the numeric value of the
 receiver.  Positive values do not include a leading + ."

^ self asString asSymbol
]

{ #category : 'HashTree-Core' }
SmallInteger >> permutedHashA: a c: c d: d [
	"With the receiver, a non-negative SmallInteger x
	and three constants a, c, and d,
	compute 
	f(x) = dx^2 + ax + c (mod 2^60)

	This function will compute a full permutation on the interval [0 .. 2^60),
	as long as 
		a, c, and d are all less than the modulus
		c is odd
		d is a-1 mod 4 (i.e. the low two bits of d = low two bits of a-1).

	A full permutation means that every possible input in the interval 
	will produce a different output in the interval.

	For good spreading of small integers, choose a and c to be large
	primes, and d should also be large, but less than the modulus.

	This primitive can also be used to compute permutations with modulo
	powers of two smaller than 2^60. Choose a, c, and d appropriately,
	and use bitAnd to discard the high-order bits of the result."

	"Should not fail unless some argument is not a SmallInteger."

	<primitive: 255>
	a _validateClass: SmallInteger.
	c _validateClass: SmallInteger.
	d _validateClass: SmallInteger.
	^ self
		_primitiveFailed: #'permutedHashA:c:d:'
		args:
			{a.
			c.
			d}
]
