Extension { #name : 'SelectorPathEvaluator' }

{ #category : 'Traversing' }
SelectorPathEvaluator >> _traverse: anObject cachedOffsets: offsets cachedClasses: classes incomplete: incompletePathTraversal [
  | nextObj sz |
  nextObj := anObject.
  sz := self size.
  1 to: sz do: [ :i |
    | pathName |
    pathName := self at: i.
    (pathName size > 0 and: [ (pathName at: 1) == $# ])
      ifTrue: [ nextObj := nextObj perform: self termSelector ]
      ifFalse: [
        offsets == nil
          ifTrue: [ nextObj := self _nextObjectFor: nextObj at: i ]
          ifFalse: [
            nextObj := self
              _nextObjectFor: nextObj
              at: i
              offsets: offsets
              classes: classes ] ].
    (nil == nextObj and: [ i ~~ sz ])
      ifTrue: [ ^ #'_incompletePathTraversal' ].
    nextObj == #'_incompletePathTraversal'
      ifTrue: [ ^ nextObj ] ].
  ^ nextObj

]

{ #category : 'Traversing' }
SelectorPathEvaluator >> _traverseObject: anObject incompletesInto: incompleteArray incomplete: incomplete [
  "Traverse the sub-objects of the given object using the path names of the
 receiver.  This method assumes that the index is not over a set-valued
 instance variable.  For that kind of index, use the traverse:startingAt:into:
 method.  If a nil value is reached before the end of the path, place the object
 into the appropriate Array in the incompleteArray of Arrays."

  "Intended for support of PathSort ... no collection-based terms"

  | nextObj sz |
  nextObj := anObject.
  sz := self size.
  1 to: sz do: [ :i |
    | pathName |
    pathName := self at: i.
    (pathName size > 0 and: [ (pathName at: 1) == $# ])
      ifTrue: [ nextObj := nextObj perform: self termSelector ]
      ifFalse: [ nextObj := self _nextObjectFor: nextObj at: i ].
    ((nil == nextObj and: [ i ~~ sz ])
      or: [ nextObj == #'_incompletePathTraversal' ])
      ifTrue: [
        incompleteArray == nil
          ifTrue: [ ^ nil ].
        (incompleteArray at: i + 1) add: anObject.
        ^ incomplete ] ].
  ^ nextObj

]

{ #category : 'Testing' }
SelectorPathEvaluator >> hasSelectorTerm [
  "Returns true if the path has a term that indicates a selector."

  ^ false

]

{ #category : 'Private' }
SelectorPathEvaluator >> termSelector [
  "termSelector is always the last term"
  | term |
  term := self at: self size.
  ^ term copyFrom: 2 to: term size

]

{ #category : 'Testing' }
SelectorPathEvaluator >> termsRequired [
  "Answer true if receiver requires that instance variables of indexed objects are present "

  ^ false

]

{ #category : 'Traversing' }
SelectorPathEvaluator >> traverse: anObject andCompare: selector with: aValue [
  "Traverse the given object and perform the comparison operation
 on the object at the end of the path and the given value."

  "This method assumes that the index is not over a set-valued instance variable."

  "This method is intended for support of QueryExecutor only"

  self shouldNotImplement: #'traverse:andCompare:with:'

]

{ #category : 'Traversing' }
SelectorPathEvaluator >> traverse: anObject andCompare: selector withTraverser: aTraverser [
  "Traverse the given object and perform the comparison operation on the object
 at the end of the path and the value obtained by using the traverser."

  "This method assumes that the index is not over a set-valued instance variable."

  "This method is intended for support of QueryExecutor only"

  self shouldNotImplement: #'traverse:andCompare:withTraverser:'

]

{ #category : 'Traversing' }
SelectorPathEvaluator >> traverse: anObject startingAt: offset do: aBlock [
  "Traverse the sub-objects of anObject, using the path names of the receiver starting at the path name at the given offset.  For each object at the end of
 the traversal, evaluate the given block."

  | nextObj ivOffset pathName sz |
  (nil == anObject _and: [ self isIndexOnNscElements not ])
    ifTrue: [ ^ self ].
  nextObj := anObject.
  sz := self size.
  offset to: sz do: [ :i |
    " get the next object along the path "
    nil == nextObj
      ifTrue: [ ^ self ].
    pathName := self at: i.
    (pathName size > 0 and: [ (pathName at: 1) == $# ])
      ifTrue: [ nextObj := nextObj perform: self termSelector ]
      ifFalse: [
        ivOffset := nextObj class _idxIvOffsetOf: pathName.
        ivOffset == nil
          ifTrue: [
            nextObj _errorInvalidOffset: pathName.
            nextObj := nil ]
          ifFalse: [ nextObj := nextObj instVarAt: ivOffset ] ].
    (nil == nextObj _and: [ i ~= sz ])
      ifTrue: [ ^ self ] ].
  ^ aBlock value: nextObj

]
