Extension { #name : 'RcUnicodeRangeEqualityIndex' }

{ #category : 'instance creation' }
RcUnicodeRangeEqualityIndex class >> newWithCollator: anIcuCollator [
  "Create a new instance and initialize its B-tree root."

  | newOne btreeRoot |
  newOne := super new.
  newOne collator: anIcuCollator.
  btreeRoot := IndexManager current rcBtreeBasicLeafNodeClass new.
  btreeRoot collator: newOne collator.	"explicitly share invariant collator with index"
  newOne btreeRoot: btreeRoot.
  ^ newOne

]

{ #category : 'instance creation' }
RcUnicodeRangeEqualityIndex class >> newWithLastElementClass: aClass [
  self shouldNotImplement: #'newWithLastElementClass:'

]

{ #category : 'Testing' }
RcUnicodeRangeEqualityIndex >> _canCompareWith: aKey [
  "Returns whether the receiver can make B-tree comparisons with the given key."

  aKey == nil
    ifTrue: [ ^ true ].
  ^ btreeRoot _canCompare: aKey withClass: Unicode7

]

{ #category : 'Testing' }
RcUnicodeRangeEqualityIndex >> _checkSameLastElementClassAs: indexObj [
  ^ indexObj _checkSameLastElementClassAsUnicodeIndex: self

]

{ #category : 'Testing' }
RcUnicodeRangeEqualityIndex >> _checkSameLastElementClassAsEqualityIndex: equalityIndexObj [
  ^ false

]

{ #category : 'Testing' }
RcUnicodeRangeEqualityIndex >> _checkSameLastElementClassAsUnicodeIndex: aUnicodeIndexObj [
  ^ true

]

{ #category : 'Updating' }
RcUnicodeRangeEqualityIndex >> _setPathTermState [
  "For each path term but the last, indicate the need to update the index
 dictionary.  For the last path term, indicate the need to update the B-tree.
 Indicate if the last object along the path needs a dependency list."

  | lastPathTerm |
  1 to: self size - 1 do: [ :i | (self at: i) updateDict: indexDictionary ].
  lastPathTerm := self at: self size.
  lastPathTerm updateBtree: self.
  lastPathTerm needsDepList: true

]

{ #category : 'conversion' }
RcUnicodeRangeEqualityIndex >> asIndexSpecification [
  ^ (RcUnicodeIndexSpecification
    path: self pathComponentsString
    collator: self collator)
    requirePathTerms: self termsRequired;
    legacyIndex: true;
    yourself

]

{ #category : 'Accessing' }
RcUnicodeRangeEqualityIndex >> collator [
  "Returns IcuCollator to be used when comparing Unicode strings"

  ^ collator

]

{ #category : 'Accessing' }
RcUnicodeRangeEqualityIndex >> collator: anIcuCollator [
  "Set the receiver's collator. Use a copy of anIcuCollator to disallow
   changes to strength, etc, that might affect the sort ordering. "

  collator := anIcuCollator copy immediateInvariant

]

{ #category : 'Accessing' }
RcUnicodeRangeEqualityIndex >> lastElementClass [
  ^ CharacterCollection

]

{ #category : 'Accessing' }
RcUnicodeRangeEqualityIndex >> lastElementClassDescription [
  "answer a description of the lastElementClass of the receiver,
   suitable for use in an error message"

  ^ 'CharacterCollection including Unicode String classes'

]

{ #category : 'Accessing' }
RcUnicodeRangeEqualityIndex >> sortNodeClass [
  "Returns the class of SortNode to use ... use basic sort node class"

  ^ self indexManager sortNodeClass

]
