Extension { #name : 'RcUnicodeIndexSpecification' }

{ #category : 'instance creation' }
RcUnicodeIndexSpecification class >> path: aString collator: anIcuCollator [
  | res |
  (res := self new)
    path: aString;
    collator: anIcuCollator.
  ^ res

]

{ #category : 'instance creation' }
RcUnicodeIndexSpecification class >> path: aString lastElementClass: aClass [
  ^ self shouldNotImplement: #'path:lastElementClass:'

]

{ #category : 'accessing' }
RcUnicodeIndexSpecification >> _createIndex [
  | index |
  index := self equalityIndexClass newWithCollator: self collator.
  self legacyIndex
    ifFalse: [ index options: self options ].
  ^ index

]

{ #category : 'private' }
RcUnicodeIndexSpecification >> _validateLastElementClassOn: anNsc [
  "noop"



]

{ #category : 'accessing' }
RcUnicodeIndexSpecification >> collator [
  "Returns IcuCollator to be used when comparing Unicode strings"

  collator ifNil: [ collator := IcuCollator default copy immediateInvariant ].
  ^ collator

]

{ #category : 'accessing' }
RcUnicodeIndexSpecification >> collator: anIcuCollator [
  "Set the receiver's collator. Use a copy of anIcuCollator to disallow
   changes to strength, etc, that might affect the sort ordering. "

  collator := anIcuCollator copy immediateInvariant

]

{ #category : 'accessing' }
RcUnicodeIndexSpecification >> equalityIndexClass [
  ^ self legacyIndex
    ifTrue: [ RcUnicodeRangeEqualityIndex ]
    ifFalse: [ GsUnicodeRangeEqualityIndex ]

]

{ #category : 'accessing' }
RcUnicodeIndexSpecification >> indexTypePrintString [
  ^ 'unicodeIndex'

]
