"
RcKeyValueNoRebuildDictionary is a subclass of RcKeyValueDictionary.
  Instances do not automatically execute rebuildTable: when adding key/value pairs.
  This allows more concurrency in Rc replay of additions.
"
Class {
	#name : 'RcKeyValueNoRebuildDictionary',
	#superclass : 'RcKeyValueDictionary',
	#category : 'Collections-Dictionaries'
}

{ #category : 'Updating' }
RcKeyValueNoRebuildDictionary >> _at: aKey put: aValue oldValue: prevValue logging: aBoolean [

"Stores the aKey/aValue pair in the key-value dictionary.  
 Never triggers rebuild of the receiver.
 The argument aBoolean determines if an entry is placed in the redo
 log for this operation."

| hash collisionBkt oldValue |
aKey ifNil: [ ^ self _error: #rtErrNilKey ].
hash := self hashFunction: aKey.
collisionBkt := self _at: hash.
oldValue := collisionBkt at: aKey put: aValue.  "puts bucket in rcReadSet"
aBoolean ifTrue: [ 
  oldValue == aValue ifTrue:[ ^ true ]. "did not write, no need to log"
  "do not add self to rcReadSet, since no rebuild possible"
  System rcValueCacheIncrement: #size for: self by: 1 .
  self _logAt: aKey put: aValue oldValue: oldValue inCollisionBucket: collisionBkt.
] ifFalse: [ "in replay"
   oldValue ~~ prevValue ifTrue: [ ^ false ]. "collision on same key, not RC"
].
^ true

]
