"

 A ProfMonitorEntry represents a stack frame from one or more samples
 taken by a ProfMonitor instance.
"
Class {
	#name : 'ProfMonitorEntry',
	#superclass : 'Object',
	#instVars : [
		'cmethod',
		'cclass',
		'tally',
		'parents',
		'children',
		'total',
		'rcvrClass',
		'recursed',
		'root',
		'childTallies',
		'parentTallies'
	],
	#category : 'PerformanceProfiling'
}

{ #category : 'Instance Creation' }
ProfMonitorEntry class >> new [

  | pme |
  pme := self _basicNew.
  pme initialize.
  ^ pme

]

{ #category : 'Instance Creation' }
ProfMonitorEntry class >> newForClass: aClass method: aMethod receiverClass: rcvrClass [

  | pme |
  pme := self new.
  pme cclass: aClass.
  pme cmethod: aMethod.
  pme rcvrClass: rcvrClass.
  ^pme.

]

{ #category : 'Instance Creation' }
ProfMonitorEntry class >> newForClass: aClass receiverClass: rcvrClass [

  ^ self newForClass: aClass method: nil receiverClass: rcvrClass

]

{ #category : 'Instance Creation' }
ProfMonitorEntry class >> newForMethod: aMethod receiverClass: rcvrClass [

  ^ self newForClass: nil method: aMethod receiverClass: rcvrClass

]

{ #category : 'Reporting' }
ProfMonitorEntry >> asStringWidth: nameWidth [
  | str mth |
  mth := cmethod .
  mth == #GCI ifTrue:[
    str := #GCI asString width: nameWidth .
  ] ifFalse:[ | rcvCls |
    str := mth _classAndSelectorNameWidth: nameWidth .
    (mth inClass ~~ (rcvCls := rcvrClass) and:[ rcvCls ~~ Object]) ifTrue:[
      str add: ' [' ; add: rcvCls name ; add: ']' .
    ].
  ].
  ^ str

]

{ #category : 'Accessing' }
ProfMonitorEntry >> cclass [

   "Return the value of the instance variable 'cclass'."
   ^cclass

]

{ #category : 'Updating' }
ProfMonitorEntry >> cclass: newValue [

   "Modify the value of the instance variable 'cclass'."
   cclass := newValue

]

{ #category : 'Accessing' }
ProfMonitorEntry >> children [

   "Return the value of the instance variable 'children'."
   ^children
]

{ #category : 'Updating' }
ProfMonitorEntry >> children: anEntry [
  children := anEntry
]

{ #category : 'Accessing' }
ProfMonitorEntry >> childTallies [

   "Return the value of the instance variable 'childTallies'."
   ^childTallies

]

{ #category : 'Accessing' }
ProfMonitorEntry >> cmethod [

   "Return the value of the instance variable 'cmethod'."
   ^cmethod

]

{ #category : 'Updating' }
ProfMonitorEntry >> cmethod: newValue [

   "Modify the value of the instance variable 'cmethod'."
   cmethod := newValue

]

{ #category : 'Updating' }
ProfMonitorEntry >> incrementTally: anInt [

  tally := tally + anInt .
  total := total + anInt .

]

{ #category : 'Updating' }
ProfMonitorEntry >> incrementTotal: anInt [

  total := total + anInt .

]

{ #category : 'Initialization' }
ProfMonitorEntry >> initialize [

  tally := 0.
  total :=  0.
  childTallies := IdentityDictionary new.
  parentTallies := IdentityDictionary new.
  children := IdentitySet new.
  parents := IdentitySet new.
  recursed := false.

]

{ #category : 'Accessing' }
ProfMonitorEntry >> parents [

   "Return the value of the instance variable 'parents'."
   ^parents

]

{ #category : 'Accessing' }
ProfMonitorEntry >> parentTallies [

   "Return the value of the instance variable 'parentTallies'."
   ^parentTallies

]

{ #category : 'Accessing' }
ProfMonitorEntry >> rcvrClass [

   "Return the value of the instance variable 'rcvrClass'."
   ^rcvrClass

]

{ #category : 'Updating' }
ProfMonitorEntry >> rcvrClass: newValue [

   "Modify the value of the instance variable 'rcvrClass'."
   rcvrClass := newValue

]

{ #category : 'Accessing' }
ProfMonitorEntry >> recursed [

   "Return the value of the instance variable 'recursed'."
   ^recursed

]

{ #category : 'Updating' }
ProfMonitorEntry >> recursed: newValue [

   "Modify the value of the instance variable 'recursed'."
   recursed := newValue

]

{ #category : 'Accessing' }
ProfMonitorEntry >> root [

   "Return the value of the instance variable 'root'."
   ^root

]

{ #category : 'Updating' }
ProfMonitorEntry >> root: newValue [

   "Modify the value of the instance variable 'root'."
   root := newValue

]

{ #category : 'Accessing' }
ProfMonitorEntry >> tally [

   "Return the value of the instance variable 'tally'."
   ^tally

]

{ #category : 'Updating' }
ProfMonitorEntry >> tally: newValue [

   "Modify the value of the instance variable 'tally'."
   tally := newValue

]

{ #category : 'Accessing' }
ProfMonitorEntry >> total [

   "Return the value of the instance variable 'total'."
   ^total

]

{ #category : 'Updating' }
ProfMonitorEntry >> total: newValue [

   "Modify the value of the instance variable 'total'."
   total := newValue

]
