Extension { #name : 'PathPathBagEnumerator' }

{ #category : 'querying' }
PathPathBagEnumerator >> _createIvOffsetCache2For: anEvaluator [
  | cache |
  cache := anEvaluator _createIvOffsetCache.
  ivOffsetCache3 := cache at: 1.
  ivOffsetCache4 := cache at: 2

]

{ #category : 'querying' }
PathPathBagEnumerator >> _findRootValuesDo: aBlock [
  "evaluator isIndexOnRootNsc ... true"

  1 to: bag size do: [ :i |
    | obj |
    (obj := bag _at: i) ~~ nil
      ifTrue: [
        | endObj |
        endObj := evaluator2
          _traverse: obj
          cachedOffsets: ivOffsetCache2
          cachedClasses: ivOffsetCache1
          incomplete: #'_incompletePathTraversal'.
        endObj ~~ #'_incompletePathTraversal'
          ifTrue: [
            (self value: obj test: endObj)
              ifTrue: [ aBlock value: obj ] ] ] ]

]

{ #category : 'querying' }
PathPathBagEnumerator >> _findTraversedCollectionBasedValuesDo: aBlock [
  | obj |
  1 to: bag size do: [ :i |
    (obj := bag _at: i) ~~ nil
      ifTrue: [
        evaluator
          traverse: obj
          do: [ :endObj1 |
            evaluator2
              traverse: obj
              do: [ :endObj2 |
                (self value: endObj1 test: endObj2)
                  ifTrue: [ aBlock value: obj ] ] ] ] ]

]

{ #category : 'querying' }
PathPathBagEnumerator >> _findTraversedValuesDo: aBlock [
  "This method assumes that the evaluator is not over a collection-based instance variable."

  1 to: bag size do: [ :i |
    | obj |
    (obj := bag _at: i) ~~ nil
      ifTrue: [
        | endObj1 |
        endObj1 := evaluator
          _traverse: obj
          cachedOffsets: ivOffsetCache2
          cachedClasses: ivOffsetCache1
          incomplete: #'_incompletePathTraversal'.
        endObj1 ~~ #'_incompletePathTraversal'
          ifTrue: [
            | endObj2 |
            endObj2 := evaluator2
              _traverse: obj
              cachedOffsets: ivOffsetCache4
              cachedClasses: ivOffsetCache3
              incomplete: #'_incompletePathTraversal'.
            endObj2 ~~ #'_incompletePathTraversal'
              ifTrue: [
                (self value: endObj1 test: endObj2)
                  ifTrue: [ aBlock value: obj ] ] ] ] ]

]

{ #category : 'accessing' }
PathPathBagEnumerator >> evaluator2: anObject [

   "Modify the value of the instance variable 'evaluator2'."
   evaluator2 := anObject

]

{ #category : 'querying' }
PathPathBagEnumerator >> findAllValues [
  | theBlock tmpHolder result |
  theBlock := doBlock.
  theBlock
    ifNil: [
      tmpHolder := evaluator tmpHolder.
      theBlock := [ :each | tmpHolder add: each ] ].
  result := evaluator isIndexOnRootNsc
    ifTrue: [
      self _createIvOffsetCacheFor: evaluator2.
      self _findRootValuesDo: theBlock ]
    ifFalse: [
      evaluator2 isIndexOnRootNsc
        ifTrue: [
          self _createIvOffsetCacheFor: evaluator.
          self _findRootValuesDo: theBlock ]
        ifFalse: [
          evaluator isCollectionBased
            ifTrue: [ self _findTraversedCollectionBasedValuesDo: theBlock ]
            ifFalse: [
              self _createIvOffsetCache.
              self _createIvOffsetCache2For: evaluator2.
              self _findTraversedValuesDo: theBlock ] ] ].
  ^ doBlock ifNil: [ tmpHolder completeBag ] ifNotNil: [ result ]

]

{ #category : 'querying' }
PathPathBagEnumerator >> findAllValuesFor: aValue1 [
  self shouldNotImplement: #'findAllValuesFor:'

]

{ #category : 'querying' }
PathPathBagEnumerator >> findAllValuesFor: aValue1 and: aValue2 [
  self shouldNotImplement: #'findAllValuesFor:and:'

]

{ #category : 'testing' }
PathPathBagEnumerator >> value: aValue and: ignored test: endObj [
  self shouldNotImplement: #'value:and:test:'

]

{ #category : 'testing' }
PathPathBagEnumerator >> value: aValue test: endObj [
  ^ evaluator isIndexOnRootNsc
    ifTrue: [ endObj perform: selector with: aValue ]
    ifFalse: [ aValue perform: selector with: endObj ]

]
