Extension { #name : 'OptionalTermPathEvaluator' }

{ #category : 'Traversing' }
OptionalTermPathEvaluator >> _nextObjectFor: anObject at: offset offsets: offsets classes: classes [
  "Returns the next object along the path in anObject for the named instance
 variable at the given offset in the receiver."

  | ivOffset |
  (classes at: offset) ~~ anObject class
    ifTrue: [
      ivOffset := anObject class _idxIvOffsetOf: (self at: offset).
      ivOffset == nil
        ifTrue: [ ^ #'_incompletePathTraversal' ].
      classes at: offset put: anObject class.
      offsets at: offset put: ivOffset ]
    ifFalse: [ ivOffset := offsets at: offset ].
  ivOffset > anObject _primitiveSize
    ifTrue: [ ^ #'_incompletePathTraversal' ].
  ^ anObject instVarAt: ivOffset

]

{ #category : 'Testing' }
OptionalTermPathEvaluator >> termsRequired [
  "Answer true if receiver requires that instance variables of indexed objects are present "

  ^ false

]
