Extension { #name : 'MultiByteString' }

{ #category : 'Private' }
MultiByteString >> _findStringNocase: subString startingAt: startIndex collator: anIcuCollator [

"searches using a copy of anIcuCollator set to TERTIARY matches, and
 using an ICU StringSearch "
<primitive: 944>
subString _validateClasses: { String . Utf8 } .
startIndex _validateClass: SmallInteger .
(startIndex < 1) | (startIndex > self size)
  ifTrue: [ ^ self _error: #objErrBadOffsetIncomplete args: { startIndex } ].
^ self _primitiveFailed: #_findStringNocase:startingAt:collator:
       args: { subString . startIndex . anIcuCollator }

]

{ #category : 'New Indexing Comparison' }
MultiByteString >> _idxUnicodeCompareEqualTo: aCharCollection [

"This comparison operation is used for the indexing subsystem to
 determine an ordering for insertion into indexing objects and for
 doing indexing subsystem comparisons.

 This method behaves the same as the = method, except that
 it returns true if the argument is nil."

  aCharCollection ifNil: [ ^ false ].
  aCharCollection isUnicodeString ifFalse: [ "not Unicode"
     aCharCollection _isSymbol ifTrue:[ ^ false ] .
  ].

  ^ (self
    compareTo: aCharCollection
    collator: nil
    useMinSize: 900) == 0

]

{ #category : 'New Indexing Comparison' }
MultiByteString >> _idxUnicodeCompareGreaterThan: aCharCollection [

"This comparison operation is used for the indexing subsystem to
 determine an ordering for insertion into indexing objects and for
 doing indexing subsystem comparisons.

 This method collates the same as the > method, except that
 it returns true if the argument is nil."

aCharCollection ifNil: [ ^ true ].
^ (self
    compareTo: aCharCollection
    collator: nil
    useMinSize: 900) == 1

]

{ #category : 'New Indexing Comparison' }
MultiByteString >> _idxUnicodeCompareLessThan: aCharCollection [

"This comparison operation is used for the indexing subsystem to
 determine an ordering for insertion into indexing objects and for
 doing indexing subsystem comparisons.

 This method collates the same as the < method, except that
 it returns false if the argument is nil."

 aCharCollection ifNil:[ ^ false ].
 ^ (self
    compareTo: aCharCollection
    collator: nil
    useMinSize: 900) == -1

]

{ #category : 'Comparing' }
MultiByteString >> _unicodeEqual: argString [
  "Compares receiver to argument using  IcuCollator default."

^ self _equals: argString collator: nil useMinSize: false

]

{ #category : 'Comparing' }
MultiByteString >> _unicodeGreaterThan: argString [
  "Compares receiver to argument using  IcuCollator default."
  ^ (self compareTo: argString collator: nil useMinSize: false) > 0

]

{ #category : 'Comparing' }
MultiByteString >> _unicodeLessThan: argString [
  "Compares receiver to argument using  IcuCollator default."
  ^ (self compareTo: argString collator: nil useMinSize: false) < 0

]

{ #category : 'Converting' }
MultiByteString >> asFoldcase [

" Returns the result of UncodeString::foldCase( U_FOLD_CASE_DEFAULT)."

<primitive: 973>
^ self _primitiveFailed: #asFoldcase

]

{ #category : 'Converting' }
MultiByteString >> asLowercaseForLocale: anIcuLocale [

"Returns the result of  UncodeString::toLower(anIcuLocale).
 The result will be a Unicode16 or Unicode32.
 See also String >> asLowercase"

<primitive: 971>
^ self _primitiveFailed: #asLowercaseForLocale: args: { anIcuLocale }

]

{ #category : 'Converting' }
MultiByteString >> asTitlecase [

  ^ self asTitlecaseForLocale: IcuLocale default

]

{ #category : 'Converting' }
MultiByteString >> asTitlecaseForLocale: anIcuLocale [

"Returns the result of
 UncodeString::toTitle(BreakIterator::createTitleInstance(anIcuLocale)"

<primitive: 972>
^ self _primitiveFailed: #asTitlecaseForLocale: args: { anIcuLocale }

]

{ #category : 'Converting' }
MultiByteString >> asUppercaseForLocale: anIcuLocale [

"Returns the result of  UncodeString::toUpper(anIcuLocale).
 The result may be a Unicode16 or Unicode32.
See also String >> asUppercase"

<primitive: 970>
self _primitiveFailed: #asUppercaseForLocale: args: { anIcuLocale }

]

{ #category : 'Streams' }
MultiByteString >> readStream [
  ^ ReadByteStream on: self 
]

{ #category : 'Indexing Support' }
MultiByteString >> sortKeyForCollator: anIcuCollator [

"Returns a ByteArray which is the sort key for the
 receiver produced by the specified IcuCollator.

 Calls Collator::getSortKey in coll.h of libicu."

<primitive: 975>
anIcuCollator _validateClass: IcuCollator .
^ self _primitiveFailed: #sortKeyForCollator: args: { anIcuCollator }

]
