"
IdentityKeySoftValueDictionary is a subclass of KeySoftValueDictionary
 which uses identity comparision on keys.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger
"
Class {
	#name : 'IdentityKeySoftValueDictionary',
	#superclass : 'KeySoftValueDictionary',
	#gs_reservedoop : '120577',
	#category : 'Collections-Dictionaries'
}

{ #category : 'Private' }
IdentityKeySoftValueDictionary >> _initializeWithoutClear: newSize [

"Private. Initializes the instance variables of the receiver to be an empty
 KeyValueDictionary of the specified size. Does not clear the contents
 of the receiver - assumes they are all nil."

tableSize := newSize.
numElements := 0.
numCollisions := 0.
collisionLimit := newSize * 500 . "differs from KeySoftValueDictionary"
^self

]

{ #category : 'Private' }
IdentityKeySoftValueDictionary >> collisionBucketClass [

"Returns the class of object to create when keys collide."

^ IdentitySoftCollisionBucket

]

{ #category : 'Updating' }
IdentityKeySoftValueDictionary >> collisionLimit: aLimit [
| limit tlim |
(limit := aLimit ) _isSmallInteger ifFalse:[  "gemstone64 explicit constraint check"
  ^ limit _error: #rtErrBadArgKind args: { SmallInteger }
].
(limit ~~ 536870911 and:[ limit > (tlim := tableSize * 500)]) ifTrue:[
  limit := tlim "prevent infinite recursion on bucket overflows, fix  "
] .
^ super collisionLimit: limit

]

{ #category : 'Private' }
IdentityKeySoftValueDictionary >> compareKey: key1 with: key2 [

"Returns true if key1 is identical to key2; returns false otherwise."

^ key1 == key2

]

{ #category : 'Comparing' }
IdentityKeySoftValueDictionary >> hash [

"Returns a numeric hash key for the receiver."

| hashValue |

hashValue := 97633 bitXor: (self size).
"For large dictionaries, the hash value is just a function of its size"
(self size > 64) ifTrue: [ ^ hashValue abs ].
self keysDo: [ :aKey |
   "Skip if the key is a dictionary."
   (aKey isKindOf: AbstractDictionary)
     ifFalse: [
       hashValue := hashValue bitXor: aKey identityHash
       ]
     ].
^ hashValue abs

]

{ #category : 'Hashing' }
IdentityKeySoftValueDictionary >> hashFunction: aKey [

"The hash function should perform some operation on the value of the key aKey
 which returns a value in the range 1..tableSize."

^(aKey identityHash \\ tableSize) + 1

]

{ #category : 'Accessing' }
IdentityKeySoftValueDictionary >> keys [
  | result |
  result := IdentitySet new . 
  self keysDo:[ :aKey | result add: aKey ].
  ^ result
]

{ #category : 'Hashing' }
IdentityKeySoftValueDictionary >> rebuildTable: newSize [

| oldTs newTs |
oldTs := tableSize .
super rebuildTable: newSize .
(newTs := tableSize) > oldTs ifTrue:[
  self collisionLimit: newTs * 500 . "differs from KeySoftValueDictionary"
].

]

{ #category : 'Hashing' }
IdentityKeySoftValueDictionary >> rehash [
	"Re-establish any hash invariants of the receiver.
	 Identity hashes cannot change."

]
