Extension { #name : 'IdentityIndexSpecification' }

{ #category : 'instance creation' }
IdentityIndexSpecification class >> path: aString [

	^(self new)
		path: aString;
		yourself

]

{ #category : 'instance creation' }
IdentityIndexSpecification class >> path: aString lastElementClass: aClass [

	^ self shouldNotImplement: #path:lastElementClass:

]

{ #category : 'accessing' }
IdentityIndexSpecification >> _createIndex [
  | index |
  index := self identityIndexClass new.
  self legacyIndex
    ifFalse: [ index options: self options ].
  ^ index

]

{ #category : 'accessing' }
IdentityIndexSpecification >> identityIndexClass [
  ^ self legacyIndex
    ifTrue: [ IdentityIndex ]
    ifFalse: [ GsIdentityIndex ]

]

{ #category : 'accessing' }
IdentityIndexSpecification >> indexType [

	^#identity

]

{ #category : 'accessing' }
IdentityIndexSpecification >> indexTypePrintString [
  ^ 'identityIndex'

]

{ #category : 'accessing' }
IdentityIndexSpecification >> removeIndexFrom: anNsc [
  (self isIndexedOn: anNsc)
    ifTrue: [ anNsc removeIdentityIndexOn: self path ]

]
