Extension { #name : 'IdentityIndexQueryEvaluator' }

{ #category : 'Query Select' }
IdentityIndexQueryEvaluator >> _findAllValuesIdenticalToAsNsc: aValue [
  "Answer a collecation of all values identical to aValue"

  | blk |
  blk := doBlock.
  [doBlock := nil.
  ^ self findAllValuesIdenticalTo: aValue ] ensure: [ doBlock := blk ]

]

{ #category : 'Searching' }
IdentityIndexQueryEvaluator >> _findFirstKeyNotIdenticalTo: aKey atTerm: pathTerm [

"Find the first entry with the given path term whose key is not identical to
 the given key and returns the entry's key."

^ self index indexDictionary _findFirstKeyNotIdenticalTo: aKey atTerm: pathTerm

]

{ #category : 'Query Select' }
IdentityIndexQueryEvaluator >> findAllValuesEqualTo: aValue [

"Identity indexes do not support equality comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Select' }
IdentityIndexQueryEvaluator >> findAllValuesGreaterThan: val1
andEquals: bool1
andLessThan: val2
andEquals: bool2 [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Select' }
IdentityIndexQueryEvaluator >> findAllValuesGreaterThanKey: aValue andEquals: aBoolean [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Select' }
IdentityIndexQueryEvaluator >> findAllValuesIdenticalTo: aValue [

"Returns a set of all values that satisfy the query."

| tmpHolder startPt res |

" optimize query for objects in the NSC itself "
self index isIndexOnRootNsc
    ifTrue: [
      doBlock
        ifNil: [
          " optimize query for objects in the NSC itself "
          ^ self _allIdenticalTo: aValue in: self nscRoot ].
      ^ self _allIdenticalTo: aValue in: self nscRoot do: doBlock  ].

tmpHolder := NscBuilder for: self nscRoot species new max: self sizeForNscBuilder.

startPt := self index lastPathComponentsDictionaryOffset.
self index _addAllFor: aValue
    into: tmpHolder
    offset: startPt
    pathTerm: (self index at: startPt).

res := tmpHolder completeBag.
doBlock ifNotNil: [ res do: doBlock ].
^res

]

{ #category : 'Query Select' }
IdentityIndexQueryEvaluator >> findAllValuesIdenticalTo: aValue do: aBlock [
  "Iterates over all values that satisfy the query.  "

  ^ (self findAllValuesIdenticalTo: aValue) do: aBlock

]

{ #category : 'Query Select' }
IdentityIndexQueryEvaluator >> findAllValuesLessThanKey: aValue andEquals: aBoolean [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Select' }
IdentityIndexQueryEvaluator >> findAllValuesNotEqualTo: aValue [

"Identity indexes do not support equality comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Detect' }
IdentityIndexQueryEvaluator >> findFirstValueEqualTo: aValue [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Detect' }
IdentityIndexQueryEvaluator >> findFirstValueGreaterThan: val1
andEquals: bool1
andLessThan: val2
andEquals: bool2 [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Detect' }
IdentityIndexQueryEvaluator >> findFirstValueGreaterThanKey: aValue
andEquals: aBoolean [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Detect' }
IdentityIndexQueryEvaluator >> findFirstValueIdenticalTo: aValue [

"Returns the first value that satisfies the query."

" optimize query for objects in the NSC itself "
self index isIndexOnRootNsc
    ifTrue: [
        (self nscRoot includesIdentical: aValue)
            ifTrue: [ ^ aValue ]
            ifFalse: [ ^ #_incompletePathTraversal ]
    ].

^ self _findFirstValueForKey: aValue

]

{ #category : 'Query Detect' }
IdentityIndexQueryEvaluator >> findFirstValueLessThanKey: aValue
andEquals: aBoolean [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Detect' }
IdentityIndexQueryEvaluator >> findFirstValueNotEqualTo: aValue [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]
