"
ISOLatin is a subclass of String which provides means for GemStone Smalltalk
 applications to extend the behavior of String with native-language-specific
 sorting or other behavior.

 ISOLatin inherits all of its behavior from String, and thus inherits the
 the English ASCII defaults for character set interpretation, as provided
 by the C runtime library and by Unix.

 It is the user's responsibility to create a subclass of ISOLatin and
 implement appropriate comparison methods in the subclass if an application
 requires language-specific sorting or comparison semantics.
"
Class {
	#name : 'ISOLatin',
	#superclass : 'String',
	#gs_reservedoop : '96769',
	#category : 'Collections-Strings'
}

{ #category : 'Formatting' }
ISOLatin >> printOn: aStream [

"Puts a displayable representation of the receiver on the given stream."

aStream _collection class == String ifTrue:[ aStream _convertToISOLatin ].

^ super printOn: aStream

]
