"
A dbTransient HtSetLeafNode, specialized for temporary scratch use while splitting leaf nodes
"
Class {
	#name : 'HtSetScratchLeafNode',
	#superclass : 'HtSetLeafNode',
	#gs_options : [
		'dbTransient'
	],
	#category : 'Collections-Internals'
}

{ #category : 'auditing' }
HtSetScratchLeafNode >> auditEmptyOnto: stream for: aSetDictionary [
	"I'm dbTransient, so it is legit for all of my contents to be nil.
	But if non-nil, should be correct for having been sent #removeAll."

	| identifier |
	identifier := 'ScratchSetLeafNode ' , self asOop printString , ' '.
	arraySize
		ifNotNil: [ 
			arraySize = 2027
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'arraySize is ' , arraySize printString , ', should be 2027';
						lf ] ].
	fillLine
		ifNotNil: [ 
			fillLine = 1520
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'fillLine is ' , fillLine printString , ', should be 1520';
						lf ] ].
	highestHash
		ifNotNil: [ 
			highestHash class == SmallInteger
				ifTrue: [ 
					highestHash negative
						ifTrue: [ 
							stream
								nextPutAll:
									identifier , 'highestHash should be non-negative, but is '
										, highestHash printString ] ]
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'highestHash should be a SmallInteger, but is of class '
										, highestHash class name;
						lf ] ].
	lowestHash
		ifNotNil: [ 
			lowestHash class == SmallInteger
				ifTrue: [ 
					lowestHash negative
						ifTrue: [ 
							stream
								nextPutAll:
									identifier , 'lowestHash should be non-negative, but is '
										, lowestHash printString ] ]
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'lowestHash should be a SmallInteger, but is of class '
										, lowestHash class name;
						lf ] ].
	tableSize
		ifNotNil: [ 
			tableSize = 2027
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'tableSize is ' , tableSize printString , ', should be 2027';
						lf ] ].

	tally
		ifNotNil: [ 
			tally = 0
				ifFalse: [ 
					stream
						nextPutAll: identifier , 'tally is ' , tally printString , ', should be 0';
						lf ] ].
	collection
		ifNotNil: [ 
			collection == aSetDictionary
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'collection is ' , collection printString , ' with oop '
										, collection asOop printString
										, ' should be the TreeSet I belong to';
						lf ] ]
]

{ #category : 'removing' }
HtSetScratchLeafNode >> removeAll [
	"Completely clear my contents so I'm ready to safely reuse."

  self fillFrom: 1 to: self size with: nil .
	tally := 0
]
