"
A dbTransient HtDictionaryLeafNode, specialized for temporary scratch use while splitting leaf nodes
"
Class {
	#name : 'HtDictionaryScratchLeafNode',
	#superclass : 'HtDictionaryLeafNode',
	#gs_options : [
		'dbTransient'
	],
	#category : 'Collections-Internals'
}

{ #category : 'auditing' }
HtDictionaryScratchLeafNode >> auditEmptyOnto: stream for: aTreeDictionary [
	"I'm dbTransient, so it is legit for all of my contents to be nil.
	But if non-nil, should be correct for having been sent #removeAll."

	| identifier |
	identifier := 'ScratchDictionaryLeafNode ' , self asOop printString , ' '.
	arraySize
		ifNotNil: [ 
			arraySize = 2026
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'arraySize is ' , arraySize printString , ', should be 2026';
						lf ] ].
	fillLine
		ifNotNil: [ 
			fillLine = 759
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'fillLine is ' , fillLine printString , ', should be 759';
						lf ] ].
	highestHash
		ifNotNil: [ 
			highestHash class == SmallInteger
				ifTrue: [ 
					highestHash negative
						ifTrue: [ 
							stream
								nextPutAll:
									identifier , 'highestHash should be non-negative, but is '
										, highestHash printString ] ]
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'highestHash should be a SmallInteger, but is of class '
										, highestHash class name;
						lf ] ].
	lowestHash
		ifNotNil: [ 
			lowestHash class == SmallInteger
				ifTrue: [ 
					lowestHash negative
						ifTrue: [ 
							stream
								nextPutAll:
									identifier , 'lowestHash should be non-negative, but is '
										, lowestHash printString ] ]
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'lowestHash should be a SmallInteger, but is of class '
										, lowestHash class name;
						lf ] ].
	tableSize
		ifNotNil: [ 
			tableSize = 1013
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'tableSize is ' , tableSize printString , ', should be 1013';
						lf ] ].

	tally
		ifNotNil: [ 
			tally = 0
				ifFalse: [ 
					stream
						nextPutAll: identifier , 'tally is ' , tally printString , ', should be 0';
						lf ] ].
	collection
		ifNotNil: [ 
			collection == aTreeDictionary
				ifFalse: [ 
					stream
						nextPutAll:
								identifier , 'collection is ' , collection printString , ' with oop '
										, collection asOop printString
										, ' should be the TreeDictionary I belong to';
						lf ] ]
]

{ #category : 'removing' }
HtDictionaryScratchLeafNode >> removeAll [
	"Completely clear my contents so I'm ready to safely reuse."

  self fillFrom: 1 to: self size with: nil .
	tally := 0
]
