"
GsX509CertificateChain encapsulates a TLS/SSL certificate chain. 
"
Class {
	#name : 'GsX509CertificateChain',
	#superclass : 'Array',
	#category : 'Credentials'
}

{ #category : 'Class Membership' }
GsX509CertificateChain class >> certificateSpecies [

^ GsX509Certificate

]

{ #category : 'Instance Creation' }
GsX509CertificateChain class >> newFromPemFile: fileNameString [
"Reads data from the given file name in PEM format and creates a new instance
 of the receiver. All certificates in the given file are loaded in same order
 as they appear in the PEM file.

 Raises an exception if the file is not in PEM format."

^ self tls3ArgPrim: 2 with: fileNameString with: self certificateSpecies with: 3

]

{ #category : 'Instance Creation' }
GsX509CertificateChain class >> newFromPemString: aPemString [
"Creates a new instance of the receiver based on the PEM string.
 All certificates in the given file are loaded in same order
 as they appear in the PEM string.

 Raises an exception if the string is not in PEM format."

^ self tls3ArgPrim: 3 with: aPemString with:  self certificateSpecies with: 3

]

{ #category : 'Private' }
GsX509CertificateChain class >> tls3ArgPrim: opCode with: aString with: pfArg with: type [

"
  OpCode   Function
=========================================================================
     0      New GsTlsCredential from PEM file, pfArg is the passphrase
     1      New GsTlsCredential from PEM string, pfArg is the passphrase
     2      New GsX509CertificateChain from PEM file
     3      New GsX509CertificateChain from PEM file
     4      New GsTlsPublicKey from a GsX509Certificate
     5      New GsTlsCredential from PEM file, pfArg is a file name
     6      New GsTlsCredential from PEM string, pfArg is a file name
=========================================================================

  Type      Kind
============================
    1       Private Key
    2       Public Key
    3       X509 Certificate
============================
"

<primitive: 1056>
^ self _primitiveFailed: #tls3ArgPrim:with:with:with: args: { opCode . aString . pfArg . type }

]

{ #category : 'Converting' }
GsX509CertificateChain >> asPemString [

|sz result|
sz := self size.
(sz == 1)
  ifTrue:[ ^ (self at: 1) asPemString] .

result := String new.
1 to: sz do:[:n| result addAll: (self at: n) asPemString ].
^ result

]
