"
GsTlsPublicKey encapsulates a TLS/SSL public key.
"
Class {
	#name : 'GsTlsPublicKey',
	#superclass : 'GsTlsCredential',
	#category : 'Credentials'
}

{ #category : 'Instance Creation' }
GsTlsPublicKey class >> fromCertificate: aGsX509Certificate [

"Extract the public key from the argument and return a new instance of the
 receiver."

^ self tls3ArgPrim: 4  with: aGsX509Certificate with: nil with: 2

]

{ #category : 'Class Membership' }
GsTlsPublicKey class >> isOpenSshClass [

^ false
]

{ #category : 'Instance Creation' }
GsTlsPublicKey class >> newFromPemFile: fileNameString [
"Reads data from the given file name in PEM format and creates a new instance
 of the receiver. If the PEM file contains multiple keys, only the
 first is read.

 Raises an exception if the file is not in PEM format or if
 the type of object in the file does not match the receiver."

^ self tls3ArgPrim: 0 with: fileNameString with: nil with: 2

]

{ #category : 'Instance Creation' }
GsTlsPublicKey class >> newFromPemString: aPemString [
"Creates a new instance of the receiver based on the PEM string. If the PEM
 string contains multiple keys, only the first is read.

 Raises an exception if the string is not in PEM format or if the type of
 object in the PEM string does not match the receiver."

^ self tls3ArgPrim: 1 with: aPemString with: nil with: 2

]

{ #category : 'Private' }
GsTlsPublicKey >> _validateIsNotRsaPss [
^ self sslAlgorithm ~~ #EVP_PKEY_RSA_PSS
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'Incorrect key type: illegal RSS_PSS public key']

]

{ #category : 'Private' }
GsTlsPublicKey >> _validateIsRsaPss [
^ self sslAlgorithm == #EVP_PKEY_RSA_PSS
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'Incorrect key type: expected an RSS_PSS public key']

]

{ #category : 'Converting' }
GsTlsPublicKey >> asOpenSshKey [

"Not supported. Libssh does not support importing public keys from OpenSSL PEM format."

^ self shouldNotImplement: #asOpenSshKey
]

{ #category : 'Converting' }
GsTlsPublicKey >> asOpenSshString [

"Not supported. Libssh does not support importing public keys from OpenSSL PEM format."

^ self shouldNotImplement: #asOpenSshString
]

{ #category : 'Converting' }
GsTlsPublicKey >> asOpenSshStringOneLine [

"Not supported. Libssh does not support importing public keys from OpenSSL PEM format."

^ self shouldNotImplement: #asOpenSshStringOneLine
]

{ #category : 'Converting' }
GsTlsPublicKey >> asOpenSslKey [
  ^ self
]

{ #category : 'Converting' }
GsTlsPublicKey >> asPublicKey [
 ^ self

]

{ #category : 'Testing' }
GsTlsPublicKey >> canCreateDigitalSignatures [
"Only private keys may be used to create signatures."
^ false

]

{ #category : 'Testing' }
GsTlsPublicKey >> canVerifyDigitalSignatures [
^ self supportsDigitalSignatures

]

{ #category : 'Encrypting' }
GsTlsPublicKey >> encrypt: aByteObj [
"Encrypts aByteObj using the receiver which must be an RSA public key 
 or X509 certificate object. This method supports RSA keys only.
 Encryption is performed using the RSA-OAEP padding algorithm. 

 Only small amounts of data may be encrypted using asymmetric 
 keys. The maximum allowed size of aByteObj is dependent on the 
 the number of bits in the receiver's public key. For 2048 bit keys, 
 the maximum size is 214 bytes. For 4096 bit keys, the maximum size is 
 470 bytes.

 aByteObj must be an instance of a byte class, typically ByteArray.
 Byte objects with character sizes greater than 1 are not supported.

 Returns a new instance of ByteArray containing the encrypted data.
 Raises an exception on error."

^ self tls1ArgInstPrim: 3 with: aByteObj
]

{ #category : 'Testing' }
GsTlsPublicKey >> isPrivateKey [
 ^ false

]

{ #category : 'Testing' }
GsTlsPublicKey >> isPublicKey [
 ^ true

]

{ #category : 'Testing' }
GsTlsPublicKey >> isX509Certificate [
 ^ false

]
