"
GsTestSuite is the GemStone-specific refinement of the SUnit TestSuite class.
"
Class {
	#name : 'GsTestSuite',
	#superclass : 'TestSuite',
	#category : 'SUnit-GemStone'
}

{ #category : 'Accessing' }
GsTestSuite class >> firstElementOfNRS [

  | firstElement dbfNRS |
      
  firstElement := SystemRepository fileNames at: 1.
  dbfNRS := (firstElement isKindOf: Array)
    ifTrue:  [ firstElement first ] "32-bit has an array of arrays of { extent, replicate}"
    ifFalse: [ firstElement].       "64-bit has an array of strings"
  ^ dbfNRS

]

{ #category : 'Accessing' }
GsTestSuite class >> logFilePath [

  | path |
  path := './SUnit.log'.
  ^ path .

]

{ #category : 'Converting' }
GsTestSuite >> _asExecString: runStr [
  | str lf |
  str := String new . lf := Character lf .
  str addAll:'run'; add: lf  .
  self tests do: [:each |
    (each isKindOf: TestSuite) ifTrue:[
       str addAll: (each _asExecString: runStr) .
    ] ifFalse:[
      str addAll: each class name ; addAll: runStr ;
        addAll: ' #'; addAll: each selector ; addAll: ' .'; add: lf 
    ].
  ].
  str add: $% ; add: lf .
  ^ str

]

{ #category : 'Adding' }
GsTestSuite >> addAllTestsTo: aList [

	tests do: [:each | 
		each addAllTestsTo: aList.
	].

]

{ #category : 'Accessing' }
GsTestSuite >> allTests [

	| list |
	list := OrderedCollection new.
	self addAllTestsTo: list.
	^list.

]

{ #category : 'Converting' }
GsTestSuite >> asDebugString [
^ self _asExecString: ' debug: '

]

{ #category : 'Converting' }
GsTestSuite >> asRunString [
^ self _asExecString: ' run: '

]

{ #category : 'Running' }
GsTestSuite >> errorIfDefects [

        | result list |
        result := self run.
        (list := result defects) notEmpty ifTrue: [list error: 'Found ' , list size printString , ' defects'].
        ^true.

]

{ #category : 'Formatting' }
GsTestSuite >> printFull [
  "Print without limits on size of the result String."
  | strm |
  strm := AppendStream on: String new .
  self printOn: strm .
  ^ strm contents

]

{ #category : 'Formatting' }
GsTestSuite >> printOn: aStream [
  "Print the test selectors that will be run"

  aStream nextPutAll: '( ', name asString; lf .
  tests ifNotNil:[:v | v  do:[:x | x printOn: aStream . aStream lf ]].
  aStream nextPutAll: ') ' ; lf .

]

{ #category : 'Running' }
GsTestSuite >> run [
  | result |
  result := GsTestResult new.
  GsTestCase openSunitLog: #filesystem .
  [self run: result] sunitEnsure: [self resources do: [:each | each reset]].
  GsTestCase flushLog .
  ^result

]

{ #category : 'Running' }
GsTestSuite >> run: aResult [

  self tests do: [:each |  "each may be either a TestSuite or a TestCase"
    self sunitChanged: each.
    each run: aResult
  ]

]
