"
GsSshPublicKey encapsulates an OpenSSH public key.
"
Class {
	#name : 'GsSshPublicKey',
	#superclass : 'GsTlsPublicKey',
	#category : 'Credentials'
}

{ #category : 'Class Membership' }
GsSshPublicKey class >> isOpenSshClass [

^ true
]

{ #category : 'Instance Creation' }
GsSshPublicKey class >> newFromOpenSshFile: fileNameString [
"Reads data from the given file name in OpenSSH base64 format and creates a new instance
 of the receiver. 

 Raises an exception if the file is not in OpenSSH base64 format or if
 the type of object in the file does not match the receiver."

^ self tls3ArgPrim: 7 with: fileNameString with: nil with: 2
]

{ #category : 'Instance Creation' }
GsSshPublicKey class >> newFromOpenSshString: aBase64String [
"Creates a new instance of the receiver based on the OpenSSH base64 string. 

 Raises an exception if the string is not in OpenSSH base64 format or if the type
 of object in the string does not match the receiver."

^ self tls3ArgPrim: 8 with: aBase64String with: nil with: 2
]

{ #category : 'Converting' }
GsSshPublicKey >> asOpenSshKey [
  ^ self
]

{ #category : 'Converting' }
GsSshPublicKey >> asOpenSshString [

"Returns a String representing the receiver in OpenSSH base 64 format.
 For private keys, base64 text lines are limited to 70 characters."
 
  ^ self tls0ArgInstPrim: 7
]

{ #category : 'Converting' }
GsSshPublicKey >> asOpenSshStringOneLine [

"Returns a String representing the receiver in OpenSSH base 64 format.
 Base64 text is placed on a single line"
 
  ^ self tls0ArgInstPrim: 8
]

{ #category : 'Converting' }
GsSshPublicKey >> asOpenSslKey [
  ^ self class speciesForOpenSslPublicKey newFromPemString: self asPemString
]

{ #category : 'Testing' }
GsSshPublicKey >> isPrivateKey [
 ^ false
]

{ #category : 'Testing' }
GsSshPublicKey >> isPublicKey [
 ^ true
]

{ #category : 'Testing' }
GsSshPublicKey >> isX509Certificate [
 ^ false
]
