"
GsSshPrivateKey encapsulates an OpenSSH private key.
"
Class {
	#name : 'GsSshPrivateKey',
	#superclass : 'GsTlsPrivateKey',
	#category : 'Credentials'
}

{ #category : 'Class Membership' }
GsSshPrivateKey class >> isOpenSshClass [

^ true
]

{ #category : 'Instance Creation' }
GsSshPrivateKey class >> newFromOpenSshFile: fileNameString [
"Reads data from the given file name in OpenSSH base64 format and creates
 a new instance of the receiver. 

 The following OpenSSH key types are supported: ecdsa, ed25519, rsa. 
 Note: dsa keys are no longer supported by libssh.

 Raises an exception if the file is not in OpenSSH base64 format or if
 the type of object in the file does not match the receiver or if the key 
 type is not supported.

 The private key is assumed to not have a passphrase."

^ self tls3ArgPrim: 7 with: fileNameString with: nil with: 1
]

{ #category : 'Instance Creation' }
GsSshPrivateKey class >> newFromOpenSshFile: fileNameString withPassphrase: aPf [
"Reads data from the given file name in OpenSSH base64 format and creates 
 a new instance of the receiver.

 Raises an exception if the file is not in OpenSSH base64 format or if
 the type of object in the file does not match the receiver or if the
 passphrase is incorrect."

^ self tls3ArgPrim: 7 with: fileNameString with: aPf with: 1
]

{ #category : 'Instance Creation' }
GsSshPrivateKey class >> newFromOpenSshFile: fileNameString withPassphraseFile: aPfFile [
"Reads data from the given file name in OpenSSH base64 format and the 
 passphrase from the text file aPfFile, then creates a new instance of the 
 receiver.

 The following OpenSSH key types are supported: ecdsa, ed25519, rsa. 
 Note: dsa keys are no longer supported by libssh.

 Raises an exception if the file is not in OpenSSH base64 format or if
 the type of object in the file does not match the receiver or if the key 
 type is not supported."
 
^ self tls3ArgPrim: 9 with: fileNameString with: aPfFile with: 1
]

{ #category : 'Instance Creation' }
GsSshPrivateKey class >> newFromOpenSshString: aBase64String [
"Creates a new instance of the receiver based on the OpenSSH base64 string. 

 The following OpenSSH key types are supported: ecdsa, ed25519, rsa. 
 Note: dsa keys are no longer supported by libssh.

 Raises an exception if the file is not in OpenSSH base64 format or if
 the type of object in the file does not match the receiver or if the key 
 type is not supported.

 The private key is assumed to not have a passphrase."

^ self tls3ArgPrim: 8 with: aBase64String with: nil with: 1
]

{ #category : 'Instance Creation' }
GsSshPrivateKey class >> newFromOpenSshString: aBase64String withPassphrase: aPf [
"Creates a new instance of the receiver based on the OpenSSH base64 string. 

 The following OpenSSH key types are supported: ecdsa, ed25519, rsa. dsa keys are 
 no longer supported by OpenSSH.

 Raises an exception if the file is not in OpenSSH base64 format or if
 the type of object in the file does not match the receiver or if the key 
 type is not supported."

^ self tls3ArgPrim: 8 with: aBase64String with: aPf with: 1
]

{ #category : 'Instance Creation' }
GsSshPrivateKey class >> newFromOpenSshString: aBase64String withPassphraseFile: aPfFile [
"Creates a new instance of the receiver based on the OpenSSH base64 string. 

 The following OpenSSH key types are supported: ecdsa, ed25519, rsa. 
 Note: dsa keys are no longer supported by libssh.

 Raises an exception if the file is not in OpenSSH base64 format or if
 the type of object in the file does not match the receiver or if the key 
 type is not supported."

^ self tls3ArgPrim: 10 with: aBase64String with: aPfFile with: 1
]

{ #category : 'Class Membership' }
GsSshPrivateKey class >> speciesForPublicKey [
  ^ GsSshPublicKey

]

{ #category : 'Converting' }
GsSshPrivateKey >> asOpenSshKey [
  ^ self
]

{ #category : 'Converting' }
GsSshPrivateKey >> asOpenSslKey [
  ^ self class speciesForOpenSslPrivateKey newFromPemString: self asPemString
]

{ #category : 'Testing' }
GsSshPrivateKey >> isPrivateKey [
 ^ true
]

{ #category : 'Testing' }
GsSshPrivateKey >> isPublicKey [
 ^ false
]

{ #category : 'Testing' }
GsSshPrivateKey >> isX509Certificate [
 ^ false
]
