Extension { #name : 'GsSelectorPathTerm' }

{ #category : 'Updating' }
GsSelectorPathTerm >> _addChildTerm: aPathTerm [
  ImproperOperation signal:
      'Selector path term may not have child terms: ' , aPathTerm printString

]

{ #category : 'Accessing' }
GsSelectorPathTerm >> _nextObjectFor: anObject [
  "Returns the object at the instance variable that corresponds to the receiver
 path term."

  ^ anObject perform: self termSelector

]

{ #category : 'Accessing' }
GsSelectorPathTerm >> _nextObjectFor: anObject atInstVar: ivOffset [
  self shouldNotImplement: #'_nextObjectFor:atInstVar:'

]

{ #category : 'Adding' }
GsSelectorPathTerm >> addDirectMappingFor: anObject root: rootObject nsc: anNsc logging: aBoolean [
  " Update the B-tree and the dependency list for anObject."

  updateBtree ~~ nil
    ifTrue: [ updateBtree btreeAt: anObject put: anObject root: rootObject ].

]

{ #category : 'Updating Indexes' }
GsSelectorPathTerm >> addMappingsForObject: anObject root: rootObject logging: aBoolean [
  "No dependency list logic for receiver."

  | nextObj |
  (nil == anObject or: [ self size == 0 ])
    ifTrue: [ ^ self ].
  nextObj := self _nextObjectFor: anObject.	" get the next object along the path "
  updateBtree ~~ nil
    ifTrue: [ " insert an entry into the B-tree "
      (self _checkBtreeComparisonWith: nextObj)
        ifFalse: [
          ImproperOperation new
            _number:
                (ErrorSymbols at: #'rtErrRangeEqualityIndexInvalidClassKindForBtree');
            args: { nextObj class. self name. updateBtree lastElementClassDescription };
            signal ].
      updateBtree btreeAt: nextObj put: anObject root: rootObject ].
  nil == nextObj
    ifTrue: [ ^ self recordNilOnPathForRoot: rootObject ].
  1 to: children size do: [ :i | " make recursive call to add mappings "
    (children at: i)
      addMappingsForObject: nextObj
      root: rootObject
      logging: aBoolean ]

]

{ #category : 'Audit' }
GsSelectorPathTerm >> auditDepListFor: obj index: indexObj using: auditor optionalSentinel: optionalSentinel [
  "No dependency lists"

  ^ obj

]

{ #category : 'Audit' }
GsSelectorPathTerm >> auditUpdateCacheFor: anObject root: root nilOnPathRoots: nilOnPathRoots occurrences: num using: auditor [
  "verify proper accounting for objects with nil on path"

  | nextObj |
  nextObj := self _nextObjectFor: anObject.
  (nil == nextObj and: [ updateBtree isNil ])
    ifTrue: [
      | nilOnPathNum |
      nilOnPathNum := nilOnPath occurrencesOf: root.
      nilOnPathNum = num
        ifFalse: [ auditor pathTermIncorrectNilOnPathCount: self root: root got: nilOnPathNum  expected: num ].
      ^ self ].
  1 to: children size do: [ :i |
    (children at: i)
      auditUpdateCacheFor: nextObj
      root: root
      nilOnPathRoots: nilOnPathRoots
      occurrences: num
      using: auditor ]

]

{ #category : 'Updating Indexes' }
GsSelectorPathTerm >> cleanupDependencyListFor: anObject [
  ""



]

{ #category : 'Collection Based Modification' }
GsSelectorPathTerm >> findRootObjectMaps: rootObjectMap for: anObject [
  "Traverse btree nodes from receiver to leaf term. Collect rootObjects for all btree elements
   for which anObject is a key or parent of a key."

  | rootObjects nextObj |
  rootObjects := IdentityBag new.
  nextObj := self _nextObjectFor: anObject.
  updateBtree ~~ nil
    ifTrue: [
      "btree exists for receiver, collect the root objects, where anObject is the key and nextObj
       is the value."
      rootObjects := self findRootObjectMaps: rootObjectMap forKey: nextObj value: anObject ].
  ^ rootObjects

]

{ #category : 'Collection Based Modification' }
GsSelectorPathTerm >> findRootObjectMaps: rootObjectMap for: anObject oldValue: oldValue [
  "Traverse btree nodes from receiver to leaf term. Collect rootObjects for all btree elements
   for which anObject is a key or parent of a key."

  ^self findRootObjectMaps: rootObjectMap for: anObject

]

{ #category : 'Collection Based Modification' }
GsSelectorPathTerm >> findRootObjectsFor: anObject [
  "Traverse btree nodes from receiver to leaf term. Collect rootObjects for all btree elements
   for which anObject is a key or parent of a key."

  | rootObjects nextObj |
  rootObjects := IdentityBag new.
  nextObj := self _nextObjectFor: anObject.
  updateBtree ~~ nil
    ifTrue: [
      "btree exists for receiver, collect the root objects, where anObject is the key and nextObj
       is the value."
      rootObjects := self findRootObjectsForKey: nextObj value: anObject ].
  ^ rootObjects

]

{ #category : 'Collection Based Modification' }
GsSelectorPathTerm >> findRootObjectsFor: anObject oldValue: oldValue [
  "Traverse btree nodes from receiver to leaf term. Collect rootObjects for all btree elements
   for which anObject is a key or parent of a key."

  ^self findRootObjectsFor: anObject

]

{ #category : 'Testing' }
GsSelectorPathTerm >> isSelectorTerm [
  ^ true

]

{ #category : 'Accessing' }
GsSelectorPathTerm >> needsDepList [
  "receiver does not do automatic maintenance updates"

  ^ false

]

{ #category : 'Updating' }
GsSelectorPathTerm >> needsDepList: ignored [
  "receiver does not do automatic maintenance updates"


]

{ #category : 'Removing' }
GsSelectorPathTerm >> removeMappingsFor: anObject root: rootObject lastOne: aBoolean logging: doLogging [
  "Remove entries in the btree for anObject."

  | nextObj more isLast |
  self size == 0
    ifTrue: [ ^ self ].
  nextObj := self _nextObjectFor: anObject.
  updateBtree ~~ nil
    ifTrue: [
      " remove an entry from the B-tree "
      (updateBtree btreeRemoveKey: nextObj value: anObject root: rootObject)
        ifFalse: [ self _errorObjectNotInBtree: nextObj value: anObject root: rootObject ] ].
  more := false.
  nextObj ifNil: [ self removeNilOnPathForRoot: rootObject ].
  (nil ~~ nextObj and: [ children isEmpty not ])
    ifTrue: [
      aBoolean
        ifTrue: [
          | last |
          last := (children at: 1) _isLastOccurrenceInIndexFor: nextObj.
          isLast := aBoolean and: [ last ] ]
        ifFalse: [ isLast := false ].
          " make recursive call to remove mappings "
      1 to: children size do: [ :i |
        (children at: i) removeMappingsFor: nextObj root: rootObject lastOne: isLast logging: doLogging ] ]

]

{ #category : 'Accessing' }
GsSelectorPathTerm >> termSelector [
  | term |
  term := self name.
  ^ term copyFrom: 2 to: term size

]

{ #category : 'Updating Indexes' }
GsSelectorPathTerm >> undoMappingsFor: anObject lastOne: aBoolean logging: doLogging [
  "No dependency lists for anObject."


]

{ #category : 'Updating Indexes' }
GsSelectorPathTerm >> update: anObject at: ivOffset to: newValue [
  "should never be sent to the receiver as automatic index maintenance is not supported"

  self shouldNotImplement: #'update:at:to:'

]
