"
GsReferencePathParentsInfo holds the result returned from 
    GsReferencePathParentsInfo class>>#refPathParentsOf:.

Instance Variables
   target                  <Object>  The object whose parent references are being sought.
   targetFoundInSearch     <Boolean> Indicates whether the target is found in the search objects passed
                                     to GsSingleRefPathFinder>>
                                       #_refPathDoScanForParents:excludeParentRefs:onlySearchObjs:.
   additionalParentsAvailable  <Boolean> If the target object was in the search set for the last
                                     scanForParentsOf: operation, then this should always be false 
                                     and the parentOops returned contains all of the parents.
                                     If the target object was not in the search set, then it indicates
                                     whether there are more parentReferences than the one returned.
                                     Add the object to the search set for another scan to get all
                                     of the parents.
   parentOops              <GsBitmap>           The oops of each referencing (parent) object. If the target 
                                                is not found in the searchArray, only a single parent 
                                                reference can be returned.
   parentClassOops         <Array of: Integer>	An empty array if the target object was not in the 
                                                searchArray.  Otherwise, it contains the oops of the 
                                                parent objects classes.
   parentClassCounts       <Array of: Integer>  An empty array if the target object was not in the 
                                                searchArray.  Otherwise, each entry in the array is a 
                                                count of the number of parent instances of the class 
                                                with the corresponding index in the parentClassOops array.
   parentSizesInBytes	   <Array of: Integer>	An empty array if the target object was not in the 
                                                searchArray.  Otherwise, each entry is the sum of the parent 
                                                objects size in bytes for the parent instances of the class 
                                                with the corresponding index in the parentClassOops array.

"
Class {
	#name : 'GsReferencePathParentsInfo',
	#superclass : 'Object',
	#instVars : [
		'target',
		'targetFoundInSearch',
		'additionalParentsAvailable',
		'parentOops',
		'parentClassOops',
		'parentClassCounts',
		'parentSizesInBytes'
	],
	#category : 'Repository'
}

{ #category : 'Private' }
GsReferencePathParentsInfo class >> _refPathParentsOf: anObj [

"Returns a GsBitmap, an GsReferencePathParentsInfo or a String with error details"

<primitive: 1025>
^ self _primitiveFailed: #refPathParentsOf: args: { anObj }

]

{ #category : 'Accessing' }
GsReferencePathParentsInfo class >> allParentsOfOops: aGsBitmap [
"Answer a GsBitmap containing the parent objects found by the last scan of each
 child object contained in aGsBitmap."

^ self refPathParentsOf: aGsBitmap

]

{ #category : 'Accessing' }
GsReferencePathParentsInfo class >> refPathParentsOf: anObj [

"Returns an instance of GsReferencePathParentsInfo if anObj is a
 committed non-special object.

 If anObj is an instance of GsBitmap, returns new instance of
 GsBitmap containing all parent objects of all child objects contained
 in the argument GsBitmap found during the last scan.

 If anObj is not an instance of GsBitmap, it must be a committed
 non-special object, or a SmallInteger; a SmallInteger must be the
 objectId of a committed non-special object and can be resolved as
 (Object _objectForOop: anObj).

 If the _refPathDoScanForParents method was run with onlySearchObjs having
 the value true, then if the object was NOT in the search set for the scan,
 then an error is reported with the message: 'No info available for objects
 not in searchOops'."

| res |
res := self _refPathParentsOf: anObj .
res _isOneByteString ifTrue:[ ^ ArgumentError signal: res ].
^ res

]

{ #category : 'Accessing' }
GsReferencePathParentsInfo >> additionalParentsAvailable [
 "Answer whether there are known to be more parent references than were
  returned from the #refPathParentsOf: call."

^additionalParentsAvailable

]

{ #category : 'Updating' }
GsReferencePathParentsInfo >> additionalParentsAvailable: aBoolean [

additionalParentsAvailable := aBoolean

]

{ #category : 'Accessing' }
GsReferencePathParentsInfo >> parentClassCounts [
 "Answer an array containing the counts of the number of referencing object instances of the class with the corresponding
  index in the parentClassIds array.
   If the target is not found in the search objects, answer an empty array."

^parentClassCounts

]

{ #category : 'Updating' }
GsReferencePathParentsInfo >> parentClassCounts: someIntegers [

parentClassCounts := someIntegers

]

{ #category : 'Accessing' }
GsReferencePathParentsInfo >> parentClassOops [
 "Answer an array of the oops of each referencing object's class.
   If the target is not found in the search objects, answer an empty array."

^parentClassOops

]

{ #category : 'Updating' }
GsReferencePathParentsInfo >> parentClassOops: someIntegers [

parentClassOops := someIntegers

]

{ #category : 'Accessing' }
GsReferencePathParentsInfo >> parentClassReferences [
 "Answer the parent objects class reference."

^self parentClassOops collect: [:refOop | Object _objectForOop: refOop]

]

{ #category : 'Accessing' }
GsReferencePathParentsInfo >> parentOops [
 "Answer a GsBitmap containing the oops of each referencing object.
  If the target is not found in the search objects, there can only be a single parent reference returned."

^parentOops

]

{ #category : 'Accessing' }
GsReferencePathParentsInfo >> parentOopsAsArray [

 "Answer an array containing the oops of each referencing object.
  If the target is not found in the search objects, there can only be a single parent reference returned."

^parentOops asArray

]

{ #category : 'Accessing' }
GsReferencePathParentsInfo >> parentReferences [
 "Answer the parent objects referencing the target."

^self parentOops collect: [:refOop | Object _objectForOop: refOop]

]

{ #category : 'Accessing' }
GsReferencePathParentsInfo >> parentSizesInBytes [
 "Answer an array of the sum of the size in bytes (from the object header) of the referencing objects with the
  class that corresponds to the entry with the same index in the parentClassOops array.
  If the target is not found in the search objects, answer an empty array."

^parentSizesInBytes

]

{ #category : 'Updating' }
GsReferencePathParentsInfo >> parentSizesInBytes: someIntegers [

parentSizesInBytes := someIntegers

]

{ #category : 'Accessing' }
GsReferencePathParentsInfo >> target [
 "Answer the argument passed to #refPathParentsOf:."

^target

]

{ #category : 'Updating' }
GsReferencePathParentsInfo >> target: anObject [

target := anObject

]

{ #category : 'Accessing' }
GsReferencePathParentsInfo >> targetFoundInSearch [
 "Answer whether the target is found in the search objects array passed to
  Repository>>#_refPathDoScanForParents:excludeParentRefs:."

^targetFoundInSearch

]

{ #category : 'Updating' }
GsReferencePathParentsInfo >> targetFoundInSearch: aBoolean [

targetFoundInSearch := aBoolean

]
