Extension { #name : 'GsQueryLiteral' }

{ #category : 'accessing' }
GsQueryLiteral >> _idxValue [
  self subclassResponsibility: #'_idxValue'

]

{ #category : 'converting' }
GsQueryLiteral >> asFormula [
  (self _idxValue isKindOf: Boolean)
    ifFalse: [ self errorConstantPredicateMustBeBoolean ].
  ^ GsConstantConstantPredicate new
    operand1: self asReferenceAssociation;
    operator: #'unary';
    immediateInvariant

]

{ #category : 'converting' }
GsQueryLiteral >> asFormulaWithSelectorParts: selectorParts [
  ^ GsUnaryClause
    clause: self asFormula
    operator: selectorParts first inputValue asSymbol

]

{ #category : 'converting' }
GsQueryLiteral >> asFormulaWithSelectorParts: selectorParts arguments: arguments [
  ^ arguments first asReferenceAssociation
    constructFormulaWithSelector: selectorParts first inputValue
    againstConstantReferenceAssoction: self asReferenceAssociation

]

{ #category : 'converting' }
GsQueryLiteral >> asReferenceAssociation [
  ^ GsConstantReferenceAssociation newWithKey: self valuePrintString value: self _idxValue

]

{ #category : 'private' }
GsQueryLiteral >> buildGsQueryParserNodeFor: aGsQueryParser [
  aGsQueryParser build: self messages: nil

]

{ #category : 'private' }
GsQueryLiteral >> constructFormulaWithSelector: selector againstConstantReferenceAssoction: aConstantReferenceAssociation [
  ^ GsConstantConstantPredicate new
    operand1: aConstantReferenceAssociation;
    operator: selector asSymbol;
    operand2: self asReferenceAssociation;
    immediateInvariant

]

{ #category : 'private' }
GsQueryLiteral >> errorConstantPredicateMustBeBoolean [
  self error: 'Constant predicate must be Boolean'

]

{ #category : 'accessing' }
GsQueryLiteral >> valuePrintOn: aStream [
  self subclassResponsibility: #'valuePrintOn:'

]

{ #category : 'accessing' }
GsQueryLiteral >> valuePrintString [
  | aStream |
  aStream := AppendStream on: String new.
  self valuePrintOn: aStream.
  ^ aStream contents

]
