Extension { #name : 'GsQueryErrorHandlingParser' }

{ #category : 'instance creation' }
GsQueryErrorHandlingParser class >> on: aParser errorMessage: aString [
  ^ (self on: aParser) setErrorMessage: aString

]

{ #category : 'instance creation' }
GsQueryErrorHandlingParser class >> on: aParser errorMessage: aString nestMessages: aBool [
  ^ (self on: aParser)
    setErrorMessage: aString;
    nestMessages: aBool;
    yourself

]

{ #category : 'parsing' }
GsQueryErrorHandlingParser >> nestMessages [
  nestMessages ifNil: [ nestMessages := true ].
  ^ nestMessages

]

{ #category : 'parsing' }
GsQueryErrorHandlingParser >> nestMessages: aBool [
  nestMessages := aBool

]

{ #category : 'parsing' }
GsQueryErrorHandlingParser >> parseOn: aPPContext [
  | element |
  (element := parser parseOn: aPPContext) isPetitFailure
    ifTrue: [
      | msg failureElement |
      failureElement := element.
      aPPContext furthestFailure
        ifNotNil: [ :furthest |
          furthest position >= element position
            ifTrue: [ failureElement := furthest ] ].
      msg := self nestMessages
        ifTrue: [ errorMessage , ' (' , failureElement message , ')' ]
        ifFalse: [ errorMessage ].
      element := PPFailure
        message: msg
        context: aPPContext
        at: failureElement position.
      aPPContext noteDominantFailure: element ].
  ^ element

]

{ #category : 'initialization' }
GsQueryErrorHandlingParser >> setErrorMessage: aString [
  errorMessage := aString

]
