Extension { #name : 'GsQueryConjoinSetChecker' }

{ #category : 'instance creation' }
GsQueryConjoinSetChecker class >> check: aFormula on: anNsc [
  ^ self new
    formula: aFormula;
    nsc: anNsc;
    queryOptions: GsQueryOptions default;
    check

]

{ #category : 'visiting' }
GsQueryConjoinSetChecker >> acceptCompoundClause: aCompoundClause [
  "disjunctive clauses are not exposed to Bug 43764. Only conjunctive normal form
   clauses need to be checked"

  super acceptCompoundClause: aCompoundClause.
  aCompoundClause clause1 isConjunctiveNormalForm
    ifTrue: [
      self checkConjunctiveClause: aCompoundClause clause1.
      aCompoundClause clause2 isConjunctiveNormalForm
        ifTrue: [ self checkConjunctiveClause: aCompoundClause clause2 ].
      ^ self ].
  aCompoundClause clause2 isConjunctiveNormalForm
    ifTrue: [ self checkConjunctiveClause: aCompoundClause clause2 ]

]

{ #category : 'visiting' }
GsQueryConjoinSetChecker >> acceptUnaryClause: aUnaryClause [
  aUnaryClause isNegationClause
    ifTrue: [
      "If clause is  negated, the applyDeMorgansLaws has not been applied to transform the formula. Cannot correctly analyze presence of Bug 43764 unless optimized with applyDeMorgansLaws and consolidateRangePredicates options set."
      ^ GsMalformedQueryExpressionError
        bug43764QueryCannotBeAnalyzed: #'acceptUnaryClause:' ].
  super acceptUnaryClause: aUnaryClause

]

{ #category : 'checking' }
GsQueryConjoinSetChecker >> check [
  self formula isConjunctiveNormalForm
    ifTrue: [ self checkConjunctiveClause: self formula ]
    ifFalse: [
      formula isNegationClause
        ifTrue: [
          "If clause is  negated, the applyDeMorgansLaws has not been applied to transform the formula. Cannot correctly analyze presence of Bug 43764 optimized if applyDeMorgansLaws and consolidateRangePredicates options not set."
          ^ GsMalformedQueryExpressionError
            bug43764QueryCannotBeAnalyzed: #'check' ].
      self visitFormula: self formula ]

]

{ #category : 'checking' }
GsQueryConjoinSetChecker >> checkConjunctiveClause: aClause [
  GsConjunctiveClauseConjoinSetChecker check: aClause on: self nsc

]
