Extension { #name : 'GsPathPathPredicate' }

{ #category : 'private' }
GsPathPathPredicate >> _evaluators [
  "return list of evaluators associated with predicate"

  ^ {(self evaluator1).
  (self evaluator2)}

]

{ #category : 'initialization' }
GsPathPathPredicate >> _fromArray: varsArray terms: termsArray links: linksArray paths: pathsArray startingAt: i [
  self
    path2:
      (self _pathFrom: linksArray paths: pathsArray offset: (termsArray at: i + 6)).
  operator := self
    inverseOperatorFor: (self operationSelectors at: (termsArray at: i) + 1).
  self
    path1:
      (self _pathFrom: linksArray paths: pathsArray offset: (termsArray at: i + 3))

]

{ #category : 'accessing' }
GsPathPathPredicate >> _pathTerms [
  "ambiguous"

  ^ self shouldNotImplement: #'_pathTerms'

]

{ #category : 'accessing' }
GsPathPathPredicate >> bagEnumeratorFor: anOperator [
  | op enumerator |
  op := self comparisonSelectorFor: anOperator.
  (self collator == nil or: [ op == #'==' or: [ op == #'~~' ] ])
    ifTrue: [
      enumerator := PathPathBagEnumerator new
        selector: op .
        ]
    ifFalse: [
      enumerator := PathPathBagUnicodeEnumerator new
        selector: op , #'collator:';
        collator: self collator .
        ].
  enumerator
    evaluator: self evaluator1;
    evaluator2: self evaluator2 .
  ^ enumerator

]

{ #category : 'private' }
GsPathPathPredicate >> bindEvaluators [
  "unconditionally use pathEvaluatorClass"

  | pathEvaluator |
  pathEvaluator := self pathEvaluatorFor: self path1.
  evaluator1 := pathEvaluator nsc: nsc.
  pathEvaluator := self pathEvaluatorFor: self path2.
  evaluator2 := pathEvaluator nsc: nsc.
  super bindEvaluators

]

{ #category : 'querying-private' }
GsPathPathPredicate >> elementValue: anObject [
  "the pathTerms in the query will use anObject as the starting point ... analagous to an object in the nsc that is bound to a query"

  | evaluatorA evaluatorB tmp1 tmp2 |
  evaluatorA := evaluator1 ifNil: [ self pathEvaluatorFor: self path1 ].
  evaluatorB := evaluator2 ifNil: [ self pathEvaluatorFor: self path2 ].
  tmp1 := Array new.
  tmp2 := Array new.
  evaluatorA traverse: anObject startingAt: 1 into: tmp1.
  evaluatorB traverse: anObject startingAt: 1 into: tmp2.
  tmp1
    do: [ :obj1 |
      tmp2
        do: [ :obj2 |
          (obj1 perform: (self comparisonSelectorFor: self operator) with: obj2)
            ifTrue: [ ^ true ] ] ].
  ^ false

]

{ #category : 'accessing' }
GsPathPathPredicate >> elementValueEvaluator [
  "Ambiguous ... elementValue: does not use this method"

  ^ self shouldNotImplement: #'elementValueEvaluator
'

]

{ #category : 'accessing' }
GsPathPathPredicate >> evaluator [
  ^ evaluator1

]

{ #category : 'accessing' }
GsPathPathPredicate >> evaluator2 [
  ^ evaluator2

]

{ #category : 'accessing' }
GsPathPathPredicate >> evaluator2: anEvaluator [
  evaluator2 := anEvaluator

]

{ #category : 'querying-private' }
GsPathPathPredicate >> executeAndDo: aBlock using: anOperator [
  (self bagEnumeratorFor: anOperator)
    doBlock: aBlock;
    findAllValues

]

{ #category : 'querying-private' }
GsPathPathPredicate >> executeClause [
  ^ self executeClauseUsing: self operator

]

{ #category : 'querying-private' }
GsPathPathPredicate >> executeClauseNegated [
  ^ self executeClauseUsing: self operatorNegated

]

{ #category : 'querying-private' }
GsPathPathPredicate >> executeClauseUsing: anOperator [
  ^ (self bagEnumeratorFor: anOperator) findAllValues

]

{ #category : 'querying-private' }
GsPathPathPredicate >> executeNegatedAndDo: aBlock [
  ^ self executeAndDo: aBlock using: self operatorNegated

]

{ #category : 'testing' }
GsPathPathPredicate >> isPathPath [
  ^ true

]

{ #category : 'testing' }
GsPathPathPredicate >> operand1IsPath [
  ^ true

]

{ #category : 'testing' }
GsPathPathPredicate >> operand2IsPath [
  ^ true

]

{ #category : 'accessing' }
GsPathPathPredicate >> path [
  "Ambiguous - path1 and path2 both exist"

  ^ self shouldNotImplement: #'path'

]

{ #category : 'accessing' }
GsPathPathPredicate >> path1 [
  ^ self operand1 key

]

{ #category : 'accessing' }
GsPathPathPredicate >> path2 [
  ^ self operand2 key

]

{ #category : 'querying' }
GsPathPathPredicate >> readStream [
  self shouldNotImplement: #'readStream'

]

{ #category : 'transforming' }
GsPathPathPredicate >> transformCommonPaths [
  "If the predicate is a path-path and path paths are the same:
	- if operator is =, ==, <=, >= predicate will always be true.
	  Transform  to unary true query
	- otherwise the predicate will always be false.
	  Transform  to unary false query"

  (self operand1 hasSamePathAs: self operand2)
    ifFalse: [ ^ self ].
  (#(#'=' #'==' #'<=' #'>=') includes: self operator)
    ifTrue: [ ^ GsQueryPredicate constant: true ].
  ^ GsQueryPredicate constant: false

]

{ #category : 'private' }
GsPathPathPredicate >> unbindEvaluators [
  "remove all bindings"

  super unbindEvaluators.
  evaluator2 := nil

]

{ #category : 'testing' }
GsPathPathPredicate >> usesPathEvaluator [
  ^ self evaluator1 isPathEvaluator and: [ self evaluator2 isPathEvaluator ]

]
