Extension { #name : 'GsIdentityIndexQueryEvaluator' }

{ #category : 'Searching' }
GsIdentityIndexQueryEvaluator >> _findAllValuesGreaterThanKey: aKey andEquals: aBoolean [
  "Returns a BtreePlusRangeIndexReadStream that iterates over all objects in the index
 that satisfy the query."

  ^ self
    _findAllValuesGreaterThanKey: aKey
    andEquals: aBoolean
    using: self comparisonForSort

]

{ #category : 'Searching' }
GsIdentityIndexQueryEvaluator >> _findAllValuesGreaterThanKey: aKey andEquals: aBoolean using: aComparison [
  "Returns a RangeIndexReadStream that iterates over all objects in the index
 that satisfy the query."

  | array1 array2 stream doNext querySpec |
  (self index _canCompareWith: aKey)
    ifFalse: [ self _error: #'assocErrBadComparison' ].
  stream := self readStreamClass new rangeIndex: self index.
  doNext := false.
  array1 := {}.	" see if querying > or >= "
  aBoolean
    ifTrue: [
      " if >=, perform < and do a 'next' operation later "
      (self btreeRoot
        _findAllValuesLessThanKey: aKey
        andEquals: false
        into: array1
        using: aComparison)
        ifTrue: [ doNext := true ]
        ifFalse: [
          " all were greater than or equal to "
          self btreeRoot
            _putFirstIndexOfFirstChildInto: array1
            ifGreaterThanOrEqualTo: aKey
            using: aComparison ] ]
    ifFalse: [
      " if >, ask the B-tree specifically for > "
      (self btreeRoot
        _findAllValuesGreaterThanKey: aKey
        into: array1
        using: aComparison)
        ifFalse: [
          " none were greater than "
          stream currentStack: {0}.
          ^ stream ] ].
  array2 := {}.
  self btreeRoot _putLastIndexOfLastChildInto: array2.
  stream currentStack: array1.
  stream endIndex: (array2 at: 1).
  stream endNode: (array2 at: 2).
  doNext
    ifTrue: [ stream _advance ].
  querySpec := self index btreeComparisonQuerySpec
    key: aKey selector: (aBoolean
            ifTrue: [ #'>=' ]
            ifFalse: [ #'>' ]);
    yourself.
  stream streamQuerySpec: querySpec.
  ^ stream

]

{ #category : 'Searching' }
GsIdentityIndexQueryEvaluator >> _findFirstKeyNotIdenticalTo: aKey atTerm: pathTerm [
  "Returns the first key in the receiver's B-tree that is not identical to the
 given key."

  | stream key |
  stream := self btreeReadStreamClass on: self btreeRoot.
  [ stream _atEnd ] whileFalse: [ key := stream _peekKey.
      key == aKey
        ifFalse: [ ^ key ].
      stream _btreeNext ].
  ^ #'_incompletePathTraversal'

]

{ #category : 'Accessing' }
GsIdentityIndexQueryEvaluator >> btreeReadStreamClass [
  "Returns the class of btree read stream to create for query results."

  ^ index btreeReadStreamClass

]

{ #category : 'Accessing' }
GsIdentityIndexQueryEvaluator >> btreeRoot [

  ^self index btreeRoot

]

{ #category : 'Accessing' }
GsIdentityIndexQueryEvaluator >> comparisonForCompare [
  ^ self index comparisonForCompare

]

{ #category : 'Accessing' }
GsIdentityIndexQueryEvaluator >> comparisonForSort [
  ^ self index comparisonForSort

]

{ #category : 'Query Select' }
GsIdentityIndexQueryEvaluator >> findAllValuesEqualTo: aValue [

"Identity indexes do not support equality comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Select' }
GsIdentityIndexQueryEvaluator >> findAllValuesGreaterThan: val1
andEquals: bool1
andLessThan: val2
andEquals: bool2 [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Select' }
GsIdentityIndexQueryEvaluator >> findAllValuesGreaterThanKey: aValue andEquals: aBoolean [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Select' }
GsIdentityIndexQueryEvaluator >> findAllValuesIdenticalTo: aValue do: aBlock [
  "Iterates over all values that satisfy the query.  "

  ^ (self findAllValuesIdenticalTo: aValue) do: aBlock

]

{ #category : 'Query Select' }
GsIdentityIndexQueryEvaluator >> findAllValuesLessThanKey: aValue andEquals: aBoolean [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Select' }
GsIdentityIndexQueryEvaluator >> findAllValuesNotEqualTo: aValue [

"Identity indexes do not support equality comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Detect' }
GsIdentityIndexQueryEvaluator >> findFirstValueEqualTo: aValue [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Detect' }
GsIdentityIndexQueryEvaluator >> findFirstValueGreaterThan: val1
andEquals: bool1
andLessThan: val2
andEquals: bool2 [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Detect' }
GsIdentityIndexQueryEvaluator >> findFirstValueGreaterThanKey: aValue
andEquals: aBoolean [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Detect' }
GsIdentityIndexQueryEvaluator >> findFirstValueIdenticalTo: aValue [
  "Returns the first value that satisfies the query.  Since this is an identity
 comparison on a range index (which supports equality comparison), create a
 BtreeReadStream for equal values, then iterate through the values making
 the identity comparison."

  | stream |
  stream := self _findAllValuesIdenticalTo: aValue.
  stream == nil
    ifTrue: [ ^ #'_incompletePathTraversal' ].	" iterate through the stream, checking for an identical value "
  [ stream _atEnd ]
    whileFalse: [
      stream _peekKey == aValue
        ifTrue: [ ^ stream _peekRoot ].
      stream _btreeNext ].
  ^ #'_incompletePathTraversal'

]

{ #category : 'Query Detect' }
GsIdentityIndexQueryEvaluator >> findFirstValueLessThanKey: aValue
andEquals: aBoolean [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Query Detect' }
GsIdentityIndexQueryEvaluator >> findFirstValueNotEqualTo: aValue [

"Identity indexes do not support range comparison."

^ self _errorCannotInvokeRangeOperationOnIdentityIndex

]

{ #category : 'Accessing' }
GsIdentityIndexQueryEvaluator >> readStreamClass [
  "Returns the class of read stream to create for query results."

  ^ index readStreamClass

]
