Extension { #name : 'GsIdentityIndex' }

{ #category : 'Testing' }
GsIdentityIndex >> _canCompare: aKey withClass: aClass [
  "Returns whether the receiver can make B-tree comparisons with the given key."
  ^ true

]

{ #category : 'Testing' }
GsIdentityIndex >> _canCompareWith: aKey [
  "Returns whether the receiver can make B-tree comparisons with the given key."

  ^ true

]

{ #category : 'Testing' }
GsIdentityIndex >> _checkSameLastElementClassAsEqualityIndex: equalityIndexObj [
  ^ false

]

{ #category : 'Converting' }
GsIdentityIndex >> asIndexSpecification [
  ^ (IdentityIndexSpecification path: self pathComponentsString)
    options: self options;
    requirePathTerms: self termsRequired;
    yourself

]

{ #category : 'Converting' }
GsIdentityIndex >> asQueryEvaluator [
  ^ GsIdentityIndexQueryEvaluator on: self

]

{ #category : 'Comparison Operators' }
GsIdentityIndex >> comparisonForCompare [
  ^ BtreeComparisonForIdentity new

]

{ #category : 'Comparison Operators' }
GsIdentityIndex >> comparisonForSort [
  "called during creation of receiver, so initialize unset instance variables"

  ^ comparisonForSort ifNil: [ comparisonForSort := BtreeComparisonForIdentity new ]

]

{ #category : 'Accessing' }
GsIdentityIndex >> indexType [
  ^ #'identity'

]

{ #category : 'Testing' }
GsIdentityIndex >> isIdentityIndex [

"Returns true."

^ true

]
