Extension { #name : 'GsEventLogEntry' }

{ #category : 'Instance Creation' }
GsEventLogEntry class >> _new [
	^super new initialize

]

{ #category : 'Instance Creation' }
GsEventLogEntry class >> debug [

	^self _new
		_priority: self debugPriority;
		yourself

]

{ #category : 'Constants' }
GsEventLogEntry class >> debugPriority [
	^60

]

{ #category : 'Instance Creation' }
GsEventLogEntry class >> error [

	^self _new
		_priority: self errorPriority;
		yourself

]

{ #category : 'Constants' }
GsEventLogEntry class >> errorPriority [
	^20

]

{ #category : 'Instance Creation' }
GsEventLogEntry class >> fatal [

	^self _new
		_priority: self fatalPriority;
		yourself

]

{ #category : 'Constants' }
GsEventLogEntry class >> fatalPriority [
	^10

]

{ #category : 'Instance Creation' }
GsEventLogEntry class >> info [

	^self _new
		_priority: self infoPriority;
		yourself

]

{ #category : 'Constants' }
GsEventLogEntry class >> infoPriority [
	^40

]

{ #category : 'Instance Creation' }
GsEventLogEntry class >> trace [

	^self _new
		_priority: self tracePriority;
		yourself

]

{ #category : 'Constants' }
GsEventLogEntry class >> tracePriority [
	^50

]

{ #category : 'Instance Creation' }
GsEventLogEntry class >> warning [

	^self _new
		_priority: self warningPriority;
		yourself

]

{ #category : 'Constants' }
GsEventLogEntry class >> warningPriority [
	^30

]

{ #category : 'Private' }
GsEventLogEntry >> _addSystemEntryToLog [

	GsEventLog current _addSystemEntry: self

]

{ #category : 'Updating' }
GsEventLogEntry >> _priority: anInteger [
	priority := anInteger

]

{ #category : 'Actions' }
GsEventLogEntry >> addToLog [

	GsEventLog current addEntry: self

]

{ #category : 'Testing' }
GsEventLogEntry >> canBeDeleted [
	^self isInvariant not

]

{ #category : 'Actions' }
GsEventLogEntry >> deleteEntry [
	"Delete the receiver from the current GsEventLog"

	GsEventLog current deleteEntry: self

]

{ #category : 'Testing' }
GsEventLogEntry >> hasTag [

	^tag ~~ nil

]

{ #category : 'Initialization' }
GsEventLogEntry >> initialize [

	pid := System gemVersionReport at: 'processId'.
	timestamp := DateAndTime now.
	object := nil.
	label := String new.

]

{ #category : 'Testing' }
GsEventLogEntry >> isSystemEvent [
	^false

]

{ #category : 'Testing' }
GsEventLogEntry >> isUserEvent [
	^true

]

{ #category : 'Accessing' }
GsEventLogEntry >> label [
	^label

]

{ #category : 'Updating' }
GsEventLogEntry >> label: newValue [
	label := newValue

]

{ #category : 'Actions' }
GsEventLogEntry >> makeUnmodifiable [
	self immediateInvariant.

]

{ #category : 'Accessing' }
GsEventLogEntry >> object [
	^object

]

{ #category : 'Updating' }
GsEventLogEntry >> object: newValue [
	object := newValue

]

{ #category : 'Accessing' }
GsEventLogEntry >> pid [
	^pid

]

{ #category : 'Displaying' }
GsEventLogEntry >> printOn: aStream [

	aStream
		nextPutAll: self timestampString;
		tab;
		nextPutAll: self processIdentification;
		tab;
		nextPutAll: self priorityAsLabel;
		tab;
		nextPutAll: self label.
	self object notNil ifTrue:
		[aStream tab; nextPutAll: self object asString].


]

{ #category : 'Accessing' }
GsEventLogEntry >> priority [
	^priority

]

{ #category : 'Displaying' }
GsEventLogEntry >> priorityAsLabel [
	self priority = self class errorPriority ifTrue: [^'Error'].
	self priority = self class warningPriority ifTrue: [^'Warn'].
	self priority = self class infoPriority ifTrue: [^'Info'].
	self priority = self class tracePriority ifTrue: [^'Trace'].
	self priority = self class debugPriority ifTrue: [^'Debug'].
	self priority = self class fatalPriority ifTrue: [^'Fatal'].
	^'Unknown'

]

{ #category : 'Displaying' }
GsEventLogEntry >> processIdentification [
	^self pid asString

]

{ #category : 'Displaying' }
GsEventLogEntry >> report [
	| str |
	str := AppendStream on: String new.
	self printOn: str.
	^str contents

]

{ #category : 'Displaying' }
GsEventLogEntry >> subsecondDigits [
	"The number of digits of subsecond resolution for timestamps"
	^4

]

{ #category : 'Accessing' }
GsEventLogEntry >> tag [
	^tag

]

{ #category : 'Updating' }
GsEventLogEntry >> tag: newValue [
	tag := newValue

]

{ #category : 'Accessing' }
GsEventLogEntry >> timestamp [
	^timestamp

]

{ #category : 'Displaying' }
GsEventLogEntry >> timestampString [
	| s |
	s := AppendStream on: String new.
	timestamp printLocalWithSubsecondDigits: self subsecondDigits on: s.
	^s contents

]
