Extension { #name : 'GsConstantPathPredicate' }

{ #category : 'instance creation' }
GsConstantPathPredicate class >> constant: operand1 operator: operator path: operand2 [
  | res |
  (res := self new)
    constant1: operand1;
    operator: operator;
    path2: operand2 .
  ^ res

]

{ #category : 'initialization' }
GsConstantPathPredicate >> _fromArray: varsArray terms: termsArray links: linksArray paths: pathsArray startingAt: i [
  self constant1: (varsArray at: (termsArray at: i + 5)).
  operator := self operationSelectors at: (termsArray at: i) + 1.
  self
    path2:
      (self _pathFrom: linksArray paths: pathsArray offset: (termsArray at: i + 3))

]

{ #category : 'private' }
GsConstantPathPredicate >> bindEvaluators [
  evaluator1 := self
    _bindEvaluator: nsc
    for: self path
    isRangeEqualityOperation: (self isRangeEqualityOperation: self operator).
  super bindEvaluators

]

{ #category : 'transforming' }
GsConstantPathPredicate >> collapseToRangePredicateIfPossible: aPathXPredicate [
  ^ aPathXPredicate collapseToRangePredicateForConstantPathPredicate: self

]

{ #category : 'accessing' }
GsConstantPathPredicate >> constant [
  ^ self operand1 _idxValue

]

{ #category : 'accessing' }
GsConstantPathPredicate >> evaluator [
  ^ evaluator1

]

{ #category : 'querying' }
GsConstantPathPredicate >> executeAndDo: aBlock [
  ^ self executeAndDo: aBlock using: self operator

]

{ #category : 'querying-private' }
GsConstantPathPredicate >> executeAndDo: aBlock using: anOperator [
  | queryEvaluator |
  queryEvaluator := self evaluator1 asQueryEvaluator.
  queryEvaluator doBlock: aBlock.
  ^ self executeClauseUsing: anOperator queryEvaluator: queryEvaluator

]

{ #category : 'querying-private' }
GsConstantPathPredicate >> executeClause [
  ^ self executeClauseUsing: self operator

]

{ #category : 'querying-private' }
GsConstantPathPredicate >> executeClauseNegated [
  ^ self executeClauseUsing: self operatorNegated

]

{ #category : 'querying-private' }
GsConstantPathPredicate >> executeClauseUsing: anOperator [
  | queryEvaluator |
  queryEvaluator := self evaluator1 asQueryEvaluator.
  ^ self executeClauseUsing: anOperator queryEvaluator: queryEvaluator

]

{ #category : 'querying-private' }
GsConstantPathPredicate >> executeClauseUsing: anOperator queryEvaluator: queryEvaluator [
  | invertedOperator |
  invertedOperator := self inverseOperatorFor: anOperator.
  self _check: self evaluator1 compare: invertedOperator value: self constant.
  (invertedOperator == #'<' or: [ invertedOperator == #'<=' ])
    ifTrue: [
      (self constant == nil and: [ invertedOperator == #'<=' ])
        ifTrue: [ ^ queryEvaluator findAllValuesEqualTo: nil ]
        ifFalse: [
          ^ queryEvaluator
            findAllValuesLessThanKey: self constant
            andEquals: invertedOperator == #'<=' ] ].
  (invertedOperator == #'>' or: [ invertedOperator == #'>=' ])
    ifTrue: [
      (self constant == nil and: [ invertedOperator == #'>=' ])
        ifTrue: [ ^ queryEvaluator findAllValuesEqualTo: nil ]
        ifFalse: [
          ^ queryEvaluator
            findAllValuesGreaterThanKey: self constant
            andEquals: invertedOperator == #'>=' ] ].
  invertedOperator == #'='
    ifTrue: [ ^ queryEvaluator findAllValuesEqualTo: self constant ].
  invertedOperator == #'~='
    ifTrue: [ ^ queryEvaluator findAllValuesNotEqualTo: self constant ].
  invertedOperator == #'=='
    ifTrue: [ ^ queryEvaluator findAllValuesIdenticalTo: self constant ].
  invertedOperator == #'~~'
    ifTrue: [ ^ queryEvaluator findAllValuesNotIdenticalTo: self constant ]

]

{ #category : 'querying-private' }
GsConstantPathPredicate >> executeNegatedAndDo: aBlock [
  ^ self executeAndDo: aBlock using: self operatorNegated

]

{ #category : 'testing' }
GsConstantPathPredicate >> isConstantBound [
  ^ self operand1 isBound

]

{ #category : 'querying-private' }
GsConstantPathPredicate >> lastElementValue: anObject [
  "anObject is the value obtained by traversing path terms to the last value ... analgous to the last element class"

  ^ self constant
    perform: (self comparisonSelectorFor: self operator)
    with: anObject

]

{ #category : 'operators' }
GsConstantPathPredicate >> normalize [
  | res |
  (res := GsPathConstantPredicate new)
    operand1: self operand2 copy;
    evaluator1: self evaluator1;
    operator: (self inverseOperatorFor: self operator);
    operand2: self operand1 copy .
  ^ res

]

{ #category : 'testing' }
GsConstantPathPredicate >> operand2IsPath [
  ^ true

]

{ #category : 'accessing' }
GsConstantPathPredicate >> rawPath [
  ^ self operand2

]
