Extension { #name : 'GsClauseOptimizer' }

{ #category : 'visiting' }
GsClauseOptimizer >> acceptPredicate: aPredicate [
  self predicates add: aPredicate

]

{ #category : 'accessing' }
GsClauseOptimizer >> nsc: anNsc [
  super nsc: anNsc.
  nsc
    ifNotNil: [ formula := formula bindEvaluatorsFor: anNsc collator: self collator ]

]

{ #category : 'optimizing' }
GsClauseOptimizer >> optimize [
  self visitFormula: self formula.
  self runOptimizations.
  ^ self predicatesAsFormula

]

{ #category : 'accessing' }
GsClauseOptimizer >> predicates [
  predicates ifNil: [ predicates := OrderedCollection new ].
  ^ predicates

]

{ #category : 'accessing' }
GsClauseOptimizer >> predicatesAsFormula [
  | newFormula |
  newFormula := (predicates at: 1) copy.
  2 to: predicates size do: [ :index | newFormula := newFormula & (predicates at: index) copy ].
  ^ (newFormula bindEvaluatorsFor: self nsc collator: self collator)
    immediateInvariant

]

{ #category : 'optimizing' }
GsClauseOptimizer >> runOptimizations [
  "noop"


]
