Extension { #name : 'GsAbstractReferenceAssociation' }

{ #category : 'converting' }
GsAbstractReferenceAssociation >> asFormula [
  self subclassResponsibility: #asFormula

]

{ #category : 'converting' }
GsAbstractReferenceAssociation >> asFormulaWithSelectorParts: selectorParts [
  ^ GsUnaryClause
    clause: self asFormula
    operator: selectorParts first inputValue asSymbol

]

{ #category : 'converting' }
GsAbstractReferenceAssociation >> asFormulaWithSelectorParts: selectorParts arguments: arguments [
  ^ arguments first
    constructFormulaWithSelector: selectorParts first inputValue
    againstConstantReferenceAssoction: self

]

{ #category : 'converting' }
GsAbstractReferenceAssociation >> asReferenceAssociation [
  ^ self

]

{ #category : 'converting' }
GsAbstractReferenceAssociation >> asString [
    ^ self printString

]

{ #category : 'accessing' }
GsAbstractReferenceAssociation >> bind: variableName to: anObject [
  "noop"


]

{ #category : 'private' }
GsAbstractReferenceAssociation >> buildGsQueryParserNodeFor: aGsQueryParser [
  aGsQueryParser build: self messages: nil

]

{ #category : 'private' }
GsAbstractReferenceAssociation >> constructFormulaWithSelector: selector againstConstantReferenceAssoction: aConstantReferenceAssociation [
  ^ GsConstantConstantPredicate new
    operand1: aConstantReferenceAssociation;
    operator: selector asSymbol;
    operand2: self;
    immediateInvariant

]

{ #category : 'private' }
GsAbstractReferenceAssociation >> constructFormulaWithSelector: selector againstPathReferenceAssoction: aPathReferenceAssociation [
  ^ GsPathConstantPredicate new
    path1: aPathReferenceAssociation;
    operator: selector asSymbol;
    operand2: self;
    immediateInvariant

]

{ #category : 'testing' }
GsAbstractReferenceAssociation >> hasEnumeratedTerm [
  ^ false

]

{ #category : 'testing' }
GsAbstractReferenceAssociation >> hasSamePathAs: aReferenceAssoc [
  ^ false

]

{ #category : 'testing' }
GsAbstractReferenceAssociation >> isBound [
  ^ true

]

{ #category : 'printing' }
GsAbstractReferenceAssociation >> printOn: aStream [
  aStream nextPutAll: self key asString

]

{ #category : 'accessing' }
GsAbstractReferenceAssociation >> unbind [
  "remove all bindings"

  "noop"


]
