"
GemStoneX509Parameters is used by the class GsX509ExternalSession.
Instances are used as arguments to the login methods in class
GsX509ExternalSession. Instances of this class contain transient
state and may not be committed to the database.

Instance variables:

netldiPort    - SmallInteger or String - listening port of the netldi
netldiHost    - String - hostname or IP address of the netldi
certificate   - GsX509Certificate or GsX509CertificateChain - certificate or
                chain of certificates to be used for login.
caCertificate - GsX509Certificate or GsX509CertificateChain - trust anchor
                certificate(s) used to verify certificates presented by the
		netldi.
privateKey    - GsTlsPrivateKey - private key which matches certificate.
loginFlags    - SmallInteger - bit flags for login. See gci.ht for latest
                bit field definitions.
extraGemArgs  - String - extra arguments to be passed to gem executable.
dirArg        - String - working directory for the gem
logArg        - String - name of the log file for the gem.


"
Class {
	#name : 'GemStoneX509Parameters',
	#superclass : 'Object',
	#instVars : [
		'netldiPort',
		'netldiHost',
		'certificate',
		'caCertificate',
		'privateKey',
		'loginFlags',
		'extraGemArgs',
		'dirArg',
		'logArg'
	],
	#gs_options : [
		'instancesNonPersistent'
	],
	#gs_reservedoop : '250113',
	#category : 'ExternalSessions'
}

{ #category : 'Instance Creation' }
GemStoneX509Parameters class >> newFromPemFilesWithNetldiPort: aPort netldiHost: aHostOrIp certificate: aCertFn caCertificate: aCaCertFn privateKey: aKeyFn [
| result |
result := self new initialize.
result netldiPort: aPort;
       netldiHost: aHostOrIp;
       certificate: (GsX509CertificateChain newFromPemFile: aCertFn);
       caCertificate: (GsX509CertificateChain newFromPemFile: aCaCertFn);
       privateKey: (GsTlsPrivateKey newFromPemFile: aKeyFn) .
^ result

]

{ #category : 'Instance Creation' }
GemStoneX509Parameters class >> newFromPemStringsWithNetldiPort: aPort netldiHost: aHostOrIp certificate: aCertString caCertificate: aCaCertString privateKey: aKeyString [
| result |
result := self new initialize.
result netldiPort: aPort;
       netldiHost: aHostOrIp;
       certificate: (GsX509CertificateChain newFromPemString: aCertString);
       caCertificate: (GsX509CertificateChain newFromPemString: aCaCertString);
       privateKey: (GsTlsPrivateKey newFromPemString: aKeyString) .
^ result

]

{ #category : 'Instance Creation' }
GemStoneX509Parameters class >> newWithNetldiPort: aPort netldiHost: aHostOrIp certificate: aCert caCertificate: aCaCert privateKey: aKey [
| result |
result := self new initialize.
result netldiPort: aPort;
       netldiHost: aHostOrIp;
       certificate: aCert;
       caCertificate: aCaCert;
       privateKey: aKey .
^ result

]

{ #category : 'Updating' }
GemStoneX509Parameters >> addGemArg: aString [
  extraGemArgs ifNil:[ 
    extraGemArgs := aString 
  ] ifNotNil:[ 
    extraGemArgs := extraGemArgs , ' ', aString .
  ]
]

{ #category : 'Converting' }
GemStoneX509Parameters >> asGciX509LoginArg [

"Answer an instance of CPointer which represents a GciX509LoginArg derived
 from the receiver."

| cBytes |
cBytes := CByteArray gcMalloc: 80 .
cBytes
  pointerAt:  0 put: (CByteArray withAll: netldiHost asString) ;
  pointerAt:  8 put: (CByteArray withAll: netldiPort asString) ;
  pointerAt: 16 put: (CByteArray withAll: privateKey asPemString) ;
  pointerAt: 24 put: (CByteArray withAll: certificate asPemString) ;
  pointerAt: 32 put: (CByteArray withAll: caCertificate asPemString) ;
  pointerAt: 40 put: (self createCargFromInstVar: extraGemArgs) ;
  pointerAt: 48 put: (self createCargFromInstVar: dirArg) ;
  pointerAt: 56 put: (self createCargFromInstVar: logArg) ;
    int32At: 64 put: loginFlags ;
    int32At: 68 put: 1 "argsArePemStrings" ;
    int32At: 72 put: 0 "executedSessionInit" .

^ CPointer newFrom: cBytes

]

{ #category : 'Accessing' }
GemStoneX509Parameters >> caCertificate [
^ caCertificate

]

{ #category : 'Updating' }
GemStoneX509Parameters >> caCertificate: aCaCert [
caCertificate := aCaCert

]

{ #category : 'Accessing' }
GemStoneX509Parameters >> certificate [
^ certificate

]

{ #category : 'Updating' }
GemStoneX509Parameters >> certificate: aCert [
certificate := aCert

]

{ #category : 'Converting' }
GemStoneX509Parameters >> createCargFromInstVar: anObj [
^ (anObj isNil or:[anObj size == 0])
    ifTrue:[ CPointer newNull ]
   ifFalse:[ CByteArray withAll: anObj ]

]

{ #category : 'Accessing' }
GemStoneX509Parameters >> dirArg [
^ dirArg

]

{ #category : 'Updating' }
GemStoneX509Parameters >> dirArg: aString [
dirArg := aString

]

{ #category : 'Accessing' }
GemStoneX509Parameters >> extraGemArgs [
^ extraGemArgs

]

{ #category : 'Updating' }
GemStoneX509Parameters >> extraGemArgs: aString [
  extraGemArgs := aString

]

{ #category : 'Initialization' }
GemStoneX509Parameters >> initialize [
 loginFlags := 0 .
 ^ self

]

{ #category : 'Accessing' }
GemStoneX509Parameters >> logArg [
^ logArg

]

{ #category : 'Updating' }
GemStoneX509Parameters >> logArg: aString [
logArg := aString

]

{ #category : 'Accessing' }
GemStoneX509Parameters >> loginFlags [
^ loginFlags

]

{ #category : 'Updating' }
GemStoneX509Parameters >> loginFlags: anInt [
loginFlags := anInt

]

{ #category : 'Accessing' }
GemStoneX509Parameters >> netldiHost [
^ netldiHost

]

{ #category : 'Updating' }
GemStoneX509Parameters >> netldiHost: aHostOrIp [
netldiHost := aHostOrIp .

]

{ #category : 'Accessing' }
GemStoneX509Parameters >> netldiPort [
^ netldiPort

]

{ #category : 'Updating' }
GemStoneX509Parameters >> netldiPort: anInt [
netldiPort := anInt .

]

{ #category : 'Accessing' }
GemStoneX509Parameters >> privateKey [
^ privateKey

]

{ #category : 'Updating' }
GemStoneX509Parameters >> privateKey: aPrivateKey [
privateKey := aPrivateKey

]
