"
ErrorDescription is used by the class GciInterface. 
Instances describe errors returned from a remote VM.

Constraints:
	categoryOop: Integer
	number: Integer
	contextOop: Object
	message: String
	fatal: Boolean
	gciInterface: Object
"
Class {
	#name : 'ErrorDescription',
	#superclass : 'Array',
	#instVars : [
		'categoryOop',
		'number',
		'contextOop',
		'message',
		'fatal',
		'gciInterface'
	],
	#gs_reservedoop : '117761',
	#category : 'System-SessionModel'
}

{ #category : 'Accessing' }
ErrorDescription >> asString [
  ^ self printString
]

{ #category : 'Accessing' }
ErrorDescription >> category [

   "To match GciErrSType."
   ^categoryOop

]

{ #category : 'Accessing' }
ErrorDescription >> categoryOop [

   "Return the value of the instance variable 'categoryOop'."
   ^categoryOop

]

{ #category : 'Accessing' }
ErrorDescription >> context [

   "To match GciErrSType."
   ^contextOop

]

{ #category : 'Accessing' }
ErrorDescription >> contextOop [

   "Return the value of the instance variable 'contextOop'."
   ^contextOop

]

{ #category : 'Accessing' }
ErrorDescription >> fatal [

   "Return the value of the instance variable 'fatal'."
   ^fatal

]

{ #category : 'Testing' }
ErrorDescription >> isBreakPoint [

"Return whether the error is due to a breakpoint."

categoryOop ifNil: [^false].
GemStoneError asOop == categoryOop
  ifFalse: [^false].
^ #( 6005 6006 6002 6023 6024 6025) includesIdentical: number 
]

{ #category : 'Testing' }
ErrorDescription >> isPause [

"Return whether the error is due to a soft break."

categoryOop == nil
  ifTrue: [^false].
GemStoneError asOop == categoryOop
  ifFalse: [^false].
^ number == (ErrorSymbols at: #rtErrPause)

]

{ #category : 'Testing' }
ErrorDescription >> isSoftBreak [

"Return whether the error is due to a soft break."

categoryOop == nil
  ifTrue: [^false].
GemStoneError asOop == categoryOop
  ifFalse: [^false].
^ number == (ErrorSymbols at: #rtErrSoftBreak)

]

{ #category : 'Accessing' }
ErrorDescription >> message [

   "Return the value of the instance variable 'message'."
   ^message

]

{ #category : 'Accessing' }
ErrorDescription >> number [

   "Return the value of the instance variable 'number'."
   ^number

]

{ #category : 'Accessing' }
ErrorDescription >> printString [
  "Display the receiver"

| s |

s := String new.
s add: self class name.
s add: '('.

s add: 'category=' ; add: categoryOop printString ; add: ', '.
s add: 'number=' ; add: number printString ; add: ', '.
s add: 'context=' ; add: contextOop printString ; add: ', '.

message == nil ifTrue:[s add: 'message=none' ]
	ifFalse: [s add: 'message="' ; add: message printString ; add: '", '].
s add: 'fatal=' ; add: fatal printString.

s add: ')'.
^s

]
