Extension { #name : 'DoubleByteString' }

{ #category : 'Comparing' }
DoubleByteString >> _equals: argString collator: anIcuCollator useMinSize: aFalse [

"Returns true if argString compares equals to the receiver using anIcuCollator
 and if argString is not a Symbol, otherwise returns false "
<primitive: 992>
anIcuCollator ifNil:[ (System __sessionStateAt: 20) ifNil:[
  ^ self _equals: argString collator: IcuCollator default useMinSize: aFalse ]
] ifNotNil:[  anIcuCollator _validateClass: IcuCollator ].
(argString isKindOf: CharacterCollection) ifTrue:[ ^ argString = self ].
^ false

]

{ #category : 'Comparing' }
DoubleByteString >> compareTo: argString collator: anIcuCollator useMinSize: aMinSize [

"Returns -1, 0 or 1,  when receiver is less than,
 equal to, or greater than argString .
 argString must be a String, MultiByteString, or a Utf8.
 anIcuCollator == nil is interpreted as   IcuCollator default .

 If aMinSize == false, normal comparision is done.

 If aMinSize==true, compare stops at (self size min: argString size),
 which is Squeak semantics for comparison.

 If aMinSize is a SmallInteger >= 1, compare stops at
   aMinSize min: (self size min: argString size) ."
<primitive: 978>   "prim handles String, DoubleByteString args"
anIcuCollator ifNil:[
  (System __sessionStateAt: 20) ifNil:[
    ^ self compareTo: argString collator: IcuCollator default useMinSize: aMinSize ]
] ifNotNil:[ anIcuCollator _validateClass: IcuCollator ].
aMinSize _validateClasses: { Boolean . SmallInteger }.
argString _validateClasses: { String . Utf8 }.
^ self _primitiveFailed: #compareTo:collator:useMinSize:
        args: { argString . anIcuCollator . aMinSize }

]
