"
DeletedUserProfile holds the key information about a UserProfile that was deleted from AllUsers.  
An instance is created and added to AllDeletedUsers when methods such as UserProfileSet>>removeAndCleanup:, 
removeAndCleanupUserWithId:ifAbsent:, etc., are executed.

A DeletedUserProfile refers to the SymbolList of the deleted user, since that is needed to reach data that 
was referred to by the deleted user.  After a UserProfile is removed, the DeletedUserProfile should be examined
for references to data that may need to be cleaned up so they can be garbage collected.
"
Class {
	#name : 'DeletedUserProfile',
	#superclass : 'Object',
	#instVars : [
		'userId',
		'symbolList',
		'whenDeleted'
	],
	#category : 'System-Users'
}

{ #category : 'Instance Creation' }
DeletedUserProfile class >> createFrom: aUserProfile [

| result |
result := self new .
result userId: aUserProfile userId copy.
result symbolList: aUserProfile symbolList .
result whenDeleted: DateTime now .
^ result

]

{ #category : 'Accessing' }
DeletedUserProfile >> symbolList [

   "Return the value of the instance variable 'symbolList'."
   ^symbolList

]

{ #category : 'Updating' }
DeletedUserProfile >> symbolList: newValue [

   "Modify the value of the instance variable 'symbolList'."
   symbolList := newValue

]

{ #category : 'Accessing' }
DeletedUserProfile >> userId [

   "Return the value of the instance variable 'userId'."
   ^userId

]

{ #category : 'Updating' }
DeletedUserProfile >> userId: newValue [

   "Modify the value of the instance variable 'userId'."
   userId := newValue

]

{ #category : 'Accessing' }
DeletedUserProfile >> whenDeleted [

   "Return the value of the instance variable 'whenDeleted'."
   ^whenDeleted

]

{ #category : 'Updating' }
DeletedUserProfile >> whenDeleted: newValue [

   "Modify the value of the instance variable 'whenDeleted'."
   whenDeleted := newValue

]
