"
CriticalSection is a class from the Blue Book API that
provides one way of using semaphores.

Constraints:
	owner: GsProcess
	semaphore: Semaphore
"
Class {
	#name : 'CriticalSection',
	#superclass : 'Object',
	#instVars : [
		'owner',
		'semaphore'
	],
	#gs_reservedoop : '117249',
	#category : 'Kernel-Processes'
}

{ #category : 'Instance Creation' }
CriticalSection class >> new [
  "Answer a new CriticalSection"
  ^self basicNew _initialize

]

{ #category : 'Private' }
CriticalSection >> _initialize [

  owner := nil.
  semaphore := Semaphore forMutualExclusion.

]

{ #category : 'Private' }
CriticalSection >> _scheduler [

"Returns   ProcessorScheduler scheduler "
<primitive: 457>

self _primitiveFailed: #_scheduler

]

{ #category : 'Blue Book Protocol' }
CriticalSection >> critical: aBlock [
  "Wait until no other processes are sending critical to the receiver
   and then execute aBlock and return its value."

  | value activeProcess |
  activeProcess := self _scheduler activeProcess"a primitive".
  (owner == activeProcess) ifFalse: [
    semaphore wait.
    owner := activeProcess.
    value := aBlock ensure: [
      owner := nil.
      semaphore signal.
    ].
  ] ifTrue: [
    value := aBlock value.
  ].
  ^value

]
