Extension { #name : 'ConstrainedCharacterCollectionIndexSpecification' }

{ #category : 'instance creation' }
ConstrainedCharacterCollectionIndexSpecification class >> path: aString collator: anIcuCollator [
  | res |
  (res := self new)
    path: aString;
    collator: anIcuCollator .
  ^ res

]

{ #category : 'instance creation' }
ConstrainedCharacterCollectionIndexSpecification class >> path: aString lastElementClass: aClass [
  ^ self shouldNotImplement: #'path:lastElementClass:'

]

{ #category : 'accessing' }
ConstrainedCharacterCollectionIndexSpecification >> _createIndex [
  ^ (self equalityIndexClass newWithCollator: self collator)
    options: self options;
    constraintType: self constraintType;
    yourself

]

{ #category : 'private' }
ConstrainedCharacterCollectionIndexSpecification >> _validateLastElementClassOn: anNsc [
  "noop"



]

{ #category : 'accessing' }
ConstrainedCharacterCollectionIndexSpecification >> collator [
  "Returns IcuCollator to be used when comparing Unicode strings. collator may be nil."

  ^ collator

]

{ #category : 'accessing' }
ConstrainedCharacterCollectionIndexSpecification >> collator: anIcuCollatorOrNil [
  "Set the receiver's collator. Use a copy of anIcuCollator to disallow
   changes to strength, etc, that might affect the sort ordering. "

  anIcuCollatorOrNil
    ifNil: [ collator := nil ]
    ifNotNil: [ collator := anIcuCollatorOrNil copy immediateInvariant ]

]

{ #category : 'accessing' }
ConstrainedCharacterCollectionIndexSpecification >> constraintType [
  "Returns the constraintType, either #string or #symbol."

  ^ constraintType

]

{ #category : 'accessing' }
ConstrainedCharacterCollectionIndexSpecification >> constraintType: aSymbol [
  "Set the constraintType, either #string or #symbol."

  constraintType := aSymbol

]

{ #category : 'accessing' }
ConstrainedCharacterCollectionIndexSpecification >> equalityIndexClass [
  ^ GsConstrainedCharacterCollectionIndex

]

{ #category : 'accessing' }
ConstrainedCharacterCollectionIndexSpecification >> indexTypePrintString [
  ^ self constraintType == #string
    ifTrue: [ 'stringOptimizedIndex' ]
    ifFalse: [ 'symbolOptimizedIndex' ]

]
