Extension { #name : 'Collection' }

{ #category : 'Private' }
Collection >> __recursiveSize: arr [
  self do:[:elem | elem _recursiveSize: arr ].

]

{ #category : 'Private' }
Collection >> __recursiveSizeInMemory: arr [
  self do:[:elem | elem _recursiveSizeInMemory: arr ].

]

{ #category : 'Object Canonicalization' }
Collection >> _canonicalizeReferencesUsingPolicy: aReferencingObjectPolicy [

	self error: 'Unable to canonicalize references in ' , self printString.

]

{ #category : 'Private' }
Collection >> _indexObjectsFor: pathArrays [
  "Returns an Array of index objects (either PathEvaluators or
 RangeEqualityIndexes) that correspond to the paths described
 in the pathArrays (each element is an Array of Strings)."

  | pathArray indexObj indexObjs k sz |
  indexObjs := {}.
  1 to: pathArrays size do: [ :i |
    pathArray := pathArrays at: i.
    indexObj := self _findRangeIndexWithPath: pathArray.
    indexObj == nil
      ifTrue: [  | holder |
        indexObj := PathEvaluator new nsc: self.
        1 to: pathArray size do: [ :j | indexObj addLast: (pathArray at: j) ].
        holder := { indexObj  } .
        indexObj  := nil .
        indexObj :=  PathEvaluator asMostSpecificType: holder .

        indexObjs isEmpty
          ifTrue: [ indexObjs add: indexObj ]
          ifFalse: [
            " don't add a duplicate path "
            k := 1.
            sz := indexObjs size.
            [ k <= sz and: [ (indexObj hasSamePathAs: (indexObjs at: k)) not ] ]
              whileTrue: [ k := k + 1 ].
            k > sz
              ifTrue: [ indexObjs add: indexObj ] ] ]
      ifFalse: [ indexObjs add: indexObj ] ].
  ^ indexObjs

]

{ #category : 'PetitParser-Core-Converting' }
Collection >> asChoiceParser [
	^ PPChoiceParser withAll: (self collect: [ :each | each asParser ])

]

{ #category : 'Converting' }
Collection >> asGsBitmap [

"Returns a GsBitmap with the contents of the receiver."

^GsBitmap withAll: self asArray

]

{ #category : 'PetitParser-Converting' }
Collection >> asParser [
	"Create a range of characters between start and stop."

	(self allSatisfy: [ :e | e isKindOf: Character ]) ifTrue: [
		| charSet |
		charSet := PPCharSetPredicate on: [ :char | self includes: char ] .
     	^ PPPredicateObjectParser on: charSet message: 'One of these charactes expected: ', self printString.
	].


	^ super asParser
	"
		($a to:$f) asParser parse:'a'
		($a to:$f) asParser parse:'g'
	"

]

{ #category : 'PetitParser-Core-Converting' }
Collection >> asSequenceParser [
	^ PPSequenceParser withAll: (self collect: [ :each | each asParser ])

]

{ #category : 'Sorting' }
Collection >> sortWithBlock: sortBlock [

"Returns an Array containing the elements of the receiver, sorted based on the
 sortBlock. The block must take two arguments, and it should return true if the
 first argument should precede the second argument, and false if not. The
 expressions within the block are expected to by symmetrical (i.e., if the first
 arg is _less_ than the second, then the block will return false when the arguments
 are reversed and if the first arg is _equal_ to the second arg, then the block
 will return false regardless of argument order)."

  self size <= 2000 ifTrue:[ | sc |
    sc := SortedCollection sortBlock: sortBlock .
    self do:[:elem | sc add: elem ]  .
    ^ Array withAll: sc .
  ] ifFalse:[
    ^ self sortWithBlock: sortBlock  persistentRoot: nil collator: nil .
  ]

]

{ #category : 'Sorting' }
Collection >> sortWithBlock: sortBlock collator: anIcuCollator [

^ self sortWithBlock: sortBlock  persistentRoot: nil collator: anIcuCollator

]

{ #category : 'Sorting' }
Collection >> sortWithBlock: sortBlock  persistentRoot: persistentArrayOrNil [

^ self sortWithBlock: sortBlock  persistentRoot: persistentArrayOrNil collator: nil

]

{ #category : 'Sorting' }
Collection >> sortWithBlock: sortBlock  persistentRoot: persistentArrayOrNil collator: anIcuCollator [

"Returns an Array containing the elements of the receiver, sorted based on the
 sortBlock.

 If anIcuCollator == nil, the sortBlock must take two arguments.
 If anIcuCollator is an IcuCollator, then the block must take a 3rd argument which
 is an IcuCollator, as used in the blocks for IcuSortedCollection.

 The sortBlock should return true if the first argument should precede the second argument,
 and false if not. The expressions within the block are expected to by symmetrical
 (i.e., if the first arg is _less_ than the second, then the block will return false
 when the arguments are reversed and if the first arg is _equal_ to the second arg,
 then the block will return false regardless of argument order).

 If persistentArrayOrNil is notNil, then it is expected to be an empty persistent array and
 the array will be used to persist large temporary data structures created during
 the sorting operation. IndexManager>>autoCommit must be true in order for periodic
 commits to  be made during the sorting operation. When the sort operation is complete
 the persistent array will be emptied and a final commit performed. The persistentArrayOrNil
 and  IndexManager>>autoCommit should be used when a collection is so large that it
 isn't practical to allocate enough temporary memory.
"

 | sorter aColl sortNodes |
sorter := BlockSorter on: self with: sortBlock collator: anIcuCollator .
sortNodes := sorter sortNodes.
aColl := self _asCollectionForSorting.
(IndexManager autoCommit and: [ persistentArrayOrNil ~~ nil ])
  ifTrue: [
    | result obj mgr |
    (mgr := IndexManager current) executeStartingIndexMaintenance: [
      persistentArrayOrNil add: sorter.
      persistentArrayOrNil add: aColl.
      mgr _doCommit.
      1 to: aColl size do: [ :i |
        obj := aColl _at: i.
         sorter _addObject: obj
                  inNodes: sortNodes.
      ].
      result := sorter sortInto: (Array new: self size) startingAt: 1.
      persistentArrayOrNil size: 0 ].
    ^result ]
  ifFalse: [ | result obj |
    1 to: aColl size do: [ :i |
      obj := aColl _at: i.
       sorter _addObject: obj
                inNodes: sortNodes.
    ].
    result := sorter sortInto: (Array new: self size) startingAt: 1.
    ^ result
].

]
