"
A CanonStringBucket is an Array that is used in a 
 CanonSymbolDictionary .  It contains keys which have the same String
 hash value , and is sorted by value comparision of the keys.
 The comparision is done using binary comparison of the bytes of the keys.
 The hash value must be computed by using CanonStringDict >> hashFunction:

"
Class {
	#name : 'CanonStringBucket',
	#superclass : 'AbstractCollisionBucket',
	#instVars : [
		'keyValueDictionary'
	],
	#gs_options : [
		'disallowGciStore'
	],
	#gs_reservedoop : '119041',
	#category : 'Kernel-AllSymbolsSupport'
}

{ #category : 'Private' }
CanonStringBucket >> _audit [
| bsz extra nSize |
extra := (bsz := self basicSize) - (nSize := self class instSize) - numElements .
extra < 0 ifTrue:[ Error signal:'bad size'].
0 to: extra - 1 do:[:n |
  (self basicAt:(bsz - n - nSize)) ifNotNil:[ Error signal:'bad element'].
].

]

{ #category : 'Audit' }
CanonStringBucket >> _audit: parentDict offset: parentOffset [
  "Returns a SmallInteger, the number of errors found"
  | firstH sz prevSym sym errCount |
  errCount := 0 .
  GsFile gciLogServer: 'bucket ', parentOffset asString, ' oop ', self asOop asString ,
       ' numElements ', numElements asString, ' _basicSize ', (sz := self _basicSize) asString .
  keyValueDictionary == parentDict ifFalse:[
    GsFile gciLogServer:'ERROR bucket ', self asOop asString,
           ' instVar keyValueDictionary inconsistent value oop ', keyValueDictionary asOop asString .
    errCount := errCount + 1.
  ].
  1 to: numElements do:[:n | | h cmp |
    sym := self _at: n .
    sym ifNil:[ GsFile gciLogServer:'ERROR bucket ', self asOop asString,' nil _at: ', n asString
    ] ifNotNil:[
      firstH ifNil:[
        firstH := parentDict hashFunction: sym .
        GsFile gciLogServer:'bucket ', self asOop asString, ' hash is ', firstH asString .
        firstH == parentOffset ifFalse:[
          GsFile gciLogServer:'ERROR bucket ', self asOop asString, ' inconsistent first hash '.
          errCount := errCount + 1.
        ].
      ] ifNotNil:[
        h := parentDict hashFunction: sym  .
        h == firstH ifFalse:[
          GsFile gciLogServer:'ERROR bucket ', self asOop asString, ' _at: ', n asString ,' sym oop ',
            sym asOop asString, ' ', sym printString,' hash ', h asString .
          errCount := errCount + 1.
        ].
        cmp := prevSym codePointCompareTo: sym .
        cmp == -1 ifFalse:[
          GsFile gciLogServer:'ERROR bucket ', self asOop asString, ' _at: ', n asString ,' sym oop ',
            sym asOop asString, ' ', sym printString,' not > than previousSym oop ',
            prevSym asOop asString,' ', prevSym printString .
          errCount := errCount + 1.
        ].
      ].
      prevSym := sym .
    ].
  ].
  numElements + 1 to: sz do:[:j |
    sym := self _at: j .
    sym ifNotNil:[
      GsFile gciLogServer:'ERROR bucket ', self asOop asString, ' _at: ', j asString, ' non-nil oop ',
        sym asOop asString,'  ', sym printString .
      errCount := errCount + 1.
    ]
  ].
  ^ errCount
]

{ #category : 'Private' }
CanonStringBucket >> _removeAll [

"Dereferences the receiver from its parent and shrinks the receiver.
 Used while rebuilding a dictionary."

keyValueDictionary := nil.
numElements := 0.
"gs64 v3.0 don't send  size: 0"

]

{ #category : 'Enumerating' }
CanonStringBucket >> accompaniedBy: anObj keysAndValuesDo: aBlock [

"Evaluates aBlock with each of the receiver's key/value pairs as the
 2nd and 3rd arguments.
 aBlock must be a 3 argument block, with arguments anObj, key value ."

1 to: numElements do:[:idx | | aSym |
   aSym := self _at: idx  .
   aBlock value: anObj value: aSym value: aSym
].

]

{ #category : 'Adding' }
CanonStringBucket >> add: anAssociation [

"Disallowed, CanonStringBucket does not contain associations"

self shouldNotImplement: #add:

]

{ #category : 'Updating' }
CanonStringBucket >> addKey: aKey [

"All additions should be done via methods in the parent dictionary."

^ self shouldNotImplement: #addKey:

]

{ #category : 'Updating' }
CanonStringBucket >> at: aKey put: aValue keyValDict_coll: aKeyValDict [

"key-value pairs are not supported"

^ self shouldNotImplement: #at:put:keyValDict_coll:

]

{ #category : 'Updating' }
CanonStringBucket >> at: anIndex putKey: aKey [

"Disallowed, must use addKey:  or removeKey:"

self shouldNotImplement: #at:putKey: .

]

{ #category : 'Updating' }
CanonStringBucket >> at: anIndex putValue: aValue [

"Disallowed, must use addKey:  or removeKey:"

self shouldNotImplement: #at:putValue: .

]

{ #category : 'Accessing' }
CanonStringBucket >> keyAt: index [

"Returns the key at the specified index."

^ self _at: index

]

{ #category : 'Enumerating' }
CanonStringBucket >> keysAndValuesDo: aBlock [

"For each key/value pair in the receiver, evaluates the two-argument block
 aBlock with the arguments key, value.  Returns the receiver."

1 to: numElements do:[:idx | | aSym |
   aSym := self _at: idx  .
   aBlock value: aSym value: aSym
].

]

{ #category : 'Enumerating' }
CanonStringBucket >> keysDo: aBlock [

"For each key/value pair in the receiver, evaluates the one-argument block
 aBlock with the key as the argument.  Returns the receiver."

1 to: numElements do:[:idx | aBlock value: ( self _at: idx )  ] .

]

{ #category : 'Accessing' }
CanonStringBucket >> keyValueDictionary [

"Returns the value of the instance variable."

^keyValueDictionary

]

{ #category : 'Updating' }
CanonStringBucket >> keyValueDictionary: aDict [

"Updates the value of the keyValueDictionary instance variable."

keyValueDictionary := aDict

]

{ #category : 'Private' }
CanonStringBucket >> objectSecurityPolicy: anObjectSecurityPolicy [
"Assigns the receiver and all its components to the given security policy.
 Returns the receiver."

self validateSystemUser .
^ super objectSecurityPolicy: anObjectSecurityPolicy

]

{ #category : 'Private' }
CanonStringBucket >> removeKey: aKey ifAbsent: aBlock [

"Removes the specified key and returns aKey . If aKey is not found,
 returns the result of evaluating the zero-argument block aBlock."

 | keyIndex |
 keyIndex := self searchForKey: aKey.
 keyIndex == nil
 ifFalse: [
    numElements := numElements - 1.
    self _deleteNoShrinkFrom: keyIndex to: keyIndex .
    ^ aKey
    ]
 ifTrue: [ ^ self _reportKeyNotFound: aKey with: aBlock ]

]

{ #category : 'Searching' }
CanonStringBucket >> searchForKey: aKey [

"Returns the index of aKey, or if not found, nil."

<primitive: 471>
aKey _validateClass: String  .
self _primitiveFailed: #searchForKey: args: { aKey }.
self _uncontinuableError

]

{ #category : 'Accessing' }
CanonStringBucket >> tableSize [

"Returns the number of keys in the capacity of the receiver."

^self _basicSize

]

{ #category : 'Accessing' }
CanonStringBucket >> valueAt: index [

"not supported, instances hold only keys"

self shouldNotImplement: #valueAt:

]

{ #category : 'Enumerating' }
CanonStringBucket >> valuesDo: aBlock [

"For each key/value pair in the receiver, evaluates the one-argument block
 aBlock with the value as the argument.  Returns the receiver."

 self keysDo: aBlock

]
