Extension { #name : 'BtreeUnicodeRangeComparisonQuerySpec' }

{ #category : 'Accessing' }
BtreeUnicodeRangeComparisonQuerySpec >> collator [
  ^ collator

]

{ #category : 'Accessing' }
BtreeUnicodeRangeComparisonQuerySpec >> collator: anIcuCollator [
  collator :=  anIcuCollator

]

{ #category : 'Comparing' }
BtreeUnicodeRangeComparisonQuerySpec >> compare: entry using: selector1 and: selector2 [
  ^ (entry perform: selector1 with: key with: self collator)
    and: [ entry perform: selector2 with: key2 with: self collator ]

]

{ #category : 'Accessing' }
BtreeUnicodeRangeComparisonQuerySpec >> performSelectors [
  "Returns an Array of comparison operation selectors whose ordering corresponds
 to the operation selectors."

  ^ #(#'_idxForCompareLessThan:collator:' #'_idxForCompareGreaterThan:collator:' #'_idxForCompareEqualTo:collator:' #'==' #'_idxForCompareLessThanOrEqualTo:collator:' #'_idxForCompareGreaterThanOrEqualTo:collator:' #'_idxForCompareNotEqualTo:collator:' #'~~')

]
