Extension { #name : 'BtreeUnicodeComparisonQuerySpec' }

{ #category : 'Accessing' }
BtreeUnicodeComparisonQuerySpec >> collator [
  ^ collator

]

{ #category : 'Accessing' }
BtreeUnicodeComparisonQuerySpec >> collator: anIcuCollator [
  collator :=  anIcuCollator

]

{ #category : 'Comparing' }
BtreeUnicodeComparisonQuerySpec >> compare: entry using: selector [
  ^ selector numArgs == 1
    ifTrue: [ entry perform: selector with: key ]
    ifFalse: [ entry perform: selector with: key with: self collator ]

]

{ #category : 'Comparing' }
BtreeUnicodeComparisonQuerySpec >> compareKey: entry [
  ^ entry perform: (self performSelector: opCode) with: key with: self collator

]

{ #category : 'Accessing' }
BtreeUnicodeComparisonQuerySpec >> performSelectors [
  "Returns an Array of comparison operation selectors whose ordering corresponds
 to the operation selectors."

  ^ #(#'_idxForCompareLessThan:collator:' #'_idxForCompareGreaterThan:collator:' #'_idxForCompareEqualTo:collator:' #'==' #'_idxForCompareLessThanOrEqualTo:collator:' #'_idxForCompareGreaterThanOrEqualTo:collator:' #'_idxForCompareNotEqualTo:collator:' #'~~')

]
